/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.boxes.tile;

import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.tile.UpgradableBoxTile;
import ca.lukegrahamlandry.tieredshulkers.common.network.PacketHandler;
import ca.lukegrahamlandry.tieredshulkers.common.network.PacketTopStackSyncShulkerBox;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class CrystalShulkerBoxTileEntity
extends UpgradableBoxTile {
    private NonNullList<ItemStack> topStacks = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private boolean inventoryTouched;
    private boolean hadStuff;

    public CrystalShulkerBoxTileEntity(@Nullable ShulkerColour colorIn, BlockPos pos, BlockState state) {
        super(colorIn, UpgradableBoxTier.CRYSTAL, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
    }

    @Override
    public void m_6520_(NonNullList<ItemStack> contents) {
        super.m_6520_(contents);
        this.inventoryTouched = true;
    }

    public ItemStack m_8020_(int index) {
        this.inventoryTouched = true;
        return super.m_8020_(index);
    }

    public NonNullList<ItemStack> getTopItems() {
        return this.topStacks;
    }

    private void sortTopStacks() {
        int i;
        if (!this.getShulkerBoxType().isTransparent() || this.f_58857_ != null && this.f_58857_.f_46443_) {
            return;
        }
        NonNullList tempCopy = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = (ItemStack)this.m_7086_().get(i);
            if (itemStack.m_41619_()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.m_41758_((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.m_41613_() == tempCopyStack.m_41613_()) continue block0;
                tempCopyStack.m_41769_(itemStack.m_41613_());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.m_41777_());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.getTopItems().size(); ++i) {
                this.getTopItems().set(i, (Object)ItemStack.f_41583_);
            }
            if (this.f_58857_ != null) {
                BlockState iblockstate = this.f_58857_.m_8055_(this.f_58858_);
                this.f_58857_.m_7260_(this.f_58858_, iblockstate, iblockstate, 3);
            }
            return;
        }
        this.hadStuff = true;
        tempCopy.sort((stack1, stack2) -> {
            if (stack1.m_41619_()) {
                return 1;
            }
            if (stack2.m_41619_()) {
                return -1;
            }
            return stack2.m_41613_() - stack1.m_41613_();
        });
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element.m_41619_() || element.m_41613_() <= 0) continue;
            if (p == this.getTopItems().size()) break;
            this.getTopItems().set(p, (Object)element);
            ++p;
        }
        for (int i2 = p; i2 < this.getTopItems().size(); ++i2) {
            this.getTopItems().set(i2, (Object)ItemStack.f_41583_);
        }
        if (this.f_58857_ != null) {
            BlockState iblockstate = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, iblockstate, iblockstate, 3);
        }
        this.sendTopStacksPacket();
    }

    public NonNullList<ItemStack> buildItemStackDataList() {
        if (this.getShulkerBoxType().isTransparent()) {
            NonNullList sortList = NonNullList.m_122780_((int)this.getTopItems().size(), (Object)ItemStack.f_41583_);
            int pos = 0;
            for (ItemStack is : this.topStacks) {
                if (!is.m_41619_()) {
                    sortList.set(pos, (Object)is);
                } else {
                    sortList.set(pos, (Object)ItemStack.f_41583_);
                }
                ++pos;
            }
            return sortList;
        }
        return NonNullList.m_122780_((int)this.getTopItems().size(), (Object)ItemStack.f_41583_);
    }

    protected void sendTopStacksPacket() {
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        PacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)this.m_58904_().m_46865_(this.m_58899_())), new PacketTopStackSyncShulkerBox(this.m_58899_(), stacks));
    }

    public void receiveMessageFromServer(NonNullList<ItemStack> topStacks) {
        this.topStacks = topStacks;
    }
}

