/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.client.tileentity;

import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tieredshulkers", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BoxesModels {
    public static final List<ResourceLocation> IRON_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("iron", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> GOLD_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("gold", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> DIAMOND_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("diamond", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> COPPER_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("copper", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> SILVER_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("silver", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> CRYSTAL_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("crystal", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> OBSIDIAN_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(color -> BoxesModels.getShulkerBoxResourceLocation("obsidian", color)).collect(ImmutableList.toImmutableList());
    public static final List<ResourceLocation> VANILLA_SHULKER_BOX_TEXTURES = (List)Arrays.stream(ShulkerColour.values()).map(ShulkerColour::getName).map(BoxesModels::getShulkerBoxResourceLocation).collect(ImmutableList.toImmutableList());

    private static ResourceLocation getShulkerBoxResourceLocation(String typeName, String colorName) {
        return new ResourceLocation("tieredshulkers", "model/" + colorName + "/shulker_" + colorName + "_" + typeName);
    }

    private static ResourceLocation getShulkerBoxResourceLocation(String colorName) {
        return new ResourceLocation("entity/shulker/shulker_" + colorName);
    }

    public static ResourceLocation chooseShulkerBoxModel(UpgradableBoxTier type, int dyeColor) {
        switch (type) {
            case IRON: {
                return IRON_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
            case GOLD: {
                return GOLD_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
            case DIAMOND: {
                return DIAMOND_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
            case COPPER: {
                return COPPER_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
            case SILVER: {
                return SILVER_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
            case CRYSTAL: {
                return CRYSTAL_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
            case OBSIDIAN: {
                return OBSIDIAN_SHULKER_BOX_TEXTURES.get(dyeColor);
            }
        }
        return VANILLA_SHULKER_BOX_TEXTURES.get(dyeColor);
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)Sheets.f_110735_)) {
            return;
        }
        IRON_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        GOLD_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        DIAMOND_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        COPPER_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        SILVER_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        CRYSTAL_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        OBSIDIAN_SHULKER_BOX_TEXTURES.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }
}

