/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers;

import ca.lukegrahamlandry.tieredshulkers.client.screen.UpgradableBoxScreen;
import ca.lukegrahamlandry.tieredshulkers.client.tileentity.UpgradableBoxTileEntityRenderer;
import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.ShulkerBoxesRegistry;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import ca.lukegrahamlandry.tieredshulkers.common.data.BoxBlockStateProvider;
import ca.lukegrahamlandry.tieredshulkers.common.data.BoxItemModelProvider;
import ca.lukegrahamlandry.tieredshulkers.common.data.BoxLootTableProvider;
import ca.lukegrahamlandry.tieredshulkers.common.data.BoxTagProvider;
import ca.lukegrahamlandry.tieredshulkers.common.data.BoxesRecipeProvider;
import ca.lukegrahamlandry.tieredshulkers.common.network.PacketHandler;
import ca.lukegrahamlandry.tieredshulkers.common.recipes.BoxRecipeTypes;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="tieredshulkers")
public class TieredShulkersMain {
    public static final String MOD_ID = "tieredshulkers";
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("tieredshulkers"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)UpgradableBoxTier.IRON.blocks.get((Object)ShulkerColour.BLACK).get().m_5456_());
        }
    };

    public TieredShulkersMain() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(this::setupClient));
        ShulkerBoxesRegistry.register(modBus);
        BoxRecipeTypes.RECIPIES.register(modBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        for (UpgradableBoxTier tier : UpgradableBoxTier.values()) {
            MenuScreens.m_96206_(tier.menu.get(), UpgradableBoxScreen::new);
            for (ShulkerColour color : ShulkerColour.values()) {
                BlockEntityRenderers.m_173590_(tier.tiles.get((Object)color).get(), UpgradableBoxTileEntityRenderer::new);
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        ShulkerBoxDispenseBehavior behaviour = new ShulkerBoxDispenseBehavior();
        for (UpgradableBoxTier tier : UpgradableBoxTier.values()) {
            for (ShulkerColour color : ShulkerColour.values()) {
                DispenserBlock.m_52672_((ItemLike)tier.blocks.get((Object)color).get().m_5456_(), (DispenseItemBehavior)behaviour);
            }
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        if (event.includeServer()) {
            datagenerator.m_236039_(true, (DataProvider)new BoxesRecipeProvider(datagenerator));
            datagenerator.m_236039_(true, (DataProvider)new BoxLootTableProvider(datagenerator));
            datagenerator.m_236039_(true, (DataProvider)new BoxTagProvider(datagenerator, MOD_ID, event.getExistingFileHelper()));
        }
        if (event.includeClient()) {
            datagenerator.m_236039_(true, (DataProvider)new BoxBlockStateProvider(datagenerator, MOD_ID, event.getExistingFileHelper()));
            datagenerator.m_236039_(true, (DataProvider)new BoxItemModelProvider(datagenerator, MOD_ID, event.getExistingFileHelper()));
        }
    }
}

