/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core;

import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.upgrade_aquatic.client.GlowSquidSpriteUploader;
import com.teamabnormals.upgrade_aquatic.client.model.FlareModel;
import com.teamabnormals.upgrade_aquatic.client.model.GooseModel;
import com.teamabnormals.upgrade_aquatic.client.model.LionfishModel;
import com.teamabnormals.upgrade_aquatic.client.model.NautilusModel;
import com.teamabnormals.upgrade_aquatic.client.model.PerchModel;
import com.teamabnormals.upgrade_aquatic.client.model.PikeModel;
import com.teamabnormals.upgrade_aquatic.client.model.SonarWaveModel;
import com.teamabnormals.upgrade_aquatic.client.model.ThrasherModel;
import com.teamabnormals.upgrade_aquatic.client.model.UAGlowSquidModel;
import com.teamabnormals.upgrade_aquatic.client.model.UluluModel;
import com.teamabnormals.upgrade_aquatic.client.model.jellyfish.BoxJellyfishModel;
import com.teamabnormals.upgrade_aquatic.client.model.jellyfish.CassiopeaJellyfishModel;
import com.teamabnormals.upgrade_aquatic.client.model.jellyfish.ImmortalJellyfishModel;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.FlareRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.GooseRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.GreatThrasherRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.LionfishRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.NautilusRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.PerchRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.PikeRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.SonarWaveRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.ThrasherRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.UAGlowSquidRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.UluluRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.BoxJellyfishRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.CassiopeaJellyfishRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.ImmortalJellyfishRenderer;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.data.server.UAStructureRepaletterProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.modifiers.UAAdvancementModifierProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.modifiers.UABiomeModifierProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.modifiers.UALootModifierProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.tags.UABiomeTagsProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.tags.UABlockTagsProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.tags.UAEntityTypeTagsProvider;
import com.teamabnormals.upgrade_aquatic.core.data.server.tags.UAPaintingVariantTagsProvider;
import com.teamabnormals.upgrade_aquatic.core.other.UAClientCompat;
import com.teamabnormals.upgrade_aquatic.core.other.UACompat;
import com.teamabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.teamabnormals.upgrade_aquatic.core.other.UADispenseBehaviorRegistry;
import com.teamabnormals.upgrade_aquatic.core.registry.UABiomeModifierTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UALootConditions;
import com.teamabnormals.upgrade_aquatic.core.registry.UAMobEffects;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPaintingVariants;
import com.teamabnormals.upgrade_aquatic.core.registry.UAParticleTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAWorldCarvers;
import com.teamabnormals.upgrade_aquatic.core.registry.util.UAItemSubRegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="upgrade_aquatic")
public class UpgradeAquatic {
    public static final String MOD_ID = "upgrade_aquatic";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"upgrade_aquatic", helper -> helper.putSubHelper(ForgeRegistries.ITEMS, (ISubRegistryHelper)new UAItemSubRegistryHelper((RegistryHelper)helper)));

    public UpgradeAquatic() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        REGISTRY_HELPER.register(bus);
        UAMobEffects.MOB_EFFECTS.register(bus);
        UAMobEffects.POTIONS.register(bus);
        UAFeatures.FEATURES.register(bus);
        UAFeatures.UAConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        UAFeatures.UAPlacedFeatures.PLACED_FEATURES.register(bus);
        UAWorldCarvers.WORLD_CARVERS.register(bus);
        UAWorldCarvers.UAConfiguredWorldCarvers.CONFIGURED_WORLD_CARVERS.register(bus);
        UAParticleTypes.PARTICLES.register(bus);
        UADataSerializers.SERIALIZERS.register(bus);
        UABiomeModifierTypes.BIOME_MODIFIER_SERIALIZERS.register(bus);
        UALootConditions.LOOT_CONDITION_TYPES.register(bus);
        UAPaintingVariants.PAINTING_VARIANTS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::clientSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            GlowSquidSpriteUploader.init(bus);
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)UAConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)UAConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            UACompat.registerCompat();
            UAEntityTypes.registerSpawnPlacements();
            UAMobEffects.registerBrewingRecipes();
            UADispenseBehaviorRegistry.registerDispenseBehaviors();
            ObfuscationReflectionHelper.setPrivateValue(BlockBehaviour.class, (Object)Blocks.f_50628_, (Object)true, (String)"f_60445_");
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        generator.m_236039_(includeServer, (DataProvider)new UALootModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new UAAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new UABlockTagsProvider(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new UAEntityTypeTagsProvider(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new UABiomeTagsProvider(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new UAPaintingVariantTagsProvider(generator, fileHelper));
        generator.m_236039_(includeServer, UABiomeModifierProvider.create(generator, fileHelper));
        generator.m_236039_(includeServer, (DataProvider)new UAStructureRepaletterProvider(generator));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            UAItems.registerItemProperties();
            UAClientCompat.registerClientCompat();
        });
    }

    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NautilusModel.LOCATION, NautilusModel::createBodyLayer);
        event.registerLayerDefinition(PikeModel.LOCATION, PikeModel::createBodyLayer);
        event.registerLayerDefinition(LionfishModel.LOCATION, LionfishModel::createBodyLayer);
        event.registerLayerDefinition(PerchModel.LOCATION, PerchModel::createBodyLayer);
        event.registerLayerDefinition(ThrasherModel.LOCATION, ThrasherModel::createBodyLayer);
        event.registerLayerDefinition(FlareModel.LOCATION, FlareModel::createBodyLayer);
        event.registerLayerDefinition(SonarWaveModel.LOCATION, SonarWaveModel::createBodyLayer);
        event.registerLayerDefinition(UluluModel.LOCATION, UluluModel::createBodyLayer);
        event.registerLayerDefinition(UAGlowSquidModel.LOCATION, UAGlowSquidModel::createBodyLayer);
        event.registerLayerDefinition(GooseModel.LOCATION, GooseModel::createBodyLayer);
        event.registerLayerDefinition(BoxJellyfishModel.LOCATION, BoxJellyfishModel::createBodyLayer);
        event.registerLayerDefinition(CassiopeaJellyfishModel.LOCATION, CassiopeaJellyfishModel::createBodyLayer);
        event.registerLayerDefinition(ImmortalJellyfishModel.LOCATION, ImmortalJellyfishModel::createBodyLayer);
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)UAEntityTypes.NAUTILUS.get(), NautilusRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.PIKE.get(), PikeRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.LIONFISH.get(), LionfishRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.PERCH.get(), PerchRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.THRASHER.get(), ThrasherRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.GREAT_THRASHER.get(), GreatThrasherRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.FLARE.get(), FlareRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.SONAR_WAVE.get(), SonarWaveRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.ULULU.get(), UluluRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.GOOSE.get(), GooseRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.BOX_JELLYFISH.get(), BoxJellyfishRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.CASSIOPEA_JELLYFISH.get(), CassiopeaJellyfishRenderer::new);
        event.registerEntityRenderer((EntityType)UAEntityTypes.IMMORTAL_JELLYFISH.get(), ImmortalJellyfishRenderer::new);
        event.registerEntityRenderer(EntityType.f_147034_, UAGlowSquidRenderer::new);
    }
}

