/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedDoublePlantBlock;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedPlantBlock;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.Tags;

public class PickerelweedFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Supplier<BlockState> BLUE_PICKERELWEED = () -> ((Block)UABlocks.BLUE_PICKERELWEED.get()).m_49966_();
    private static final Supplier<BlockState> PURPLE_PICKERELWEED = () -> ((Block)UABlocks.PURPLE_PICKERELWEED.get()).m_49966_();

    public PickerelweedFeature(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        Holder biome = worldIn.m_204166_(pos);
        if (this.isValidBlock((LevelAccessor)worldIn, pos) && this.shouldPlace((LevelAccessor)worldIn, pos) && BLUE_PICKERELWEED.get().m_60710_((LevelReader)worldIn, pos.m_7495_())) {
            if (biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(Tags.Biomes.IS_SWAMP) || biome.m_203565_(Biomes.f_48179_)) {
                boolean purpleGen;
                if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                    purpleGen = (double)rand.m_188501_() >= 0.6;
                } else {
                    boolean bl = purpleGen = !((double)rand.m_188501_() >= 0.6);
                }
                if (rand.m_188500_() <= 0.9) {
                    this.generatePickerelweedPatch((LevelAccessor)worldIn, pos, purpleGen, rand.m_188503_(8));
                }
            } else {
                boolean purpleGen;
                if ((double)((Biome)biome.m_203334_()).m_47554_() < 0.2) {
                    purpleGen = (double)rand.m_188501_() >= 0.75;
                } else if ((double)((Biome)biome.m_203334_()).m_47554_() < 1.0) {
                    purpleGen = rand.m_188499_();
                } else {
                    boolean bl = purpleGen = !((double)rand.m_188501_() >= 0.75);
                }
                if (rand.m_188500_() <= 0.35) {
                    this.generatePickerelweedPatch((LevelAccessor)worldIn, pos, purpleGen, rand.m_188503_(8));
                }
            }
            return true;
        }
        return false;
    }

    public void generatePickerelweedPatch(LevelAccessor world, BlockPos pos, boolean purple, int randomDesign) {
        int[] patterns = new int[3];
        switch (randomDesign) {
            default: {
                patterns[0] = 4;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 1: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 2: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 12;
            }
            case 3: {
                patterns[0] = 3;
                patterns[1] = 13;
                patterns[2] = 12;
            }
            case 4: {
                patterns[0] = 4;
                patterns[1] = 3;
                patterns[2] = 6;
            }
            case 5: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 6;
            }
            case 6: {
                patterns[0] = 5;
                patterns[1] = 4;
                patterns[2] = 6;
            }
            case 7: 
        }
        patterns[0] = 5;
        patterns[1] = 4;
        patterns[2] = 6;
        BlockPos startPos = pos;
        PickerelweedDoublePlantBlock doubleplantblock = (PickerelweedDoublePlantBlock)(!purple ? (Block)UABlocks.TALL_BLUE_PICKERELWEED.get() : (Block)UABlocks.TALL_PURPLE_PICKERELWEED.get());
        MathUtil.Equation r = theta -> (Math.cos((double)patterns[1] * theta) / (double)patterns[2] + 1.0) * (double)patterns[0];
        if (!(world.m_46859_(startPos.m_7495_()) || world.m_46859_(startPos.m_6625_(2)) || world.m_46859_(startPos.m_6625_(3)))) {
            int repeatsDown = world.m_213780_().m_188503_(2) + 2;
            for (int repeats = 0; repeats < repeatsDown; ++repeats) {
                pos = pos.m_7918_(0, -repeats, 0);
                for (int i = -(patterns[0] / patterns[2] + patterns[0]); i < patterns[0] / patterns[2] + patterns[0]; ++i) {
                    for (int j = -(patterns[0] / patterns[2] + patterns[0]); j < patterns[0] / patterns[2] + patterns[0]; ++j) {
                        double radius = r.compute(Math.atan2(j, i));
                        BlockPos placingPos = pos.m_7918_(i, 0, j);
                        if (!world.m_8055_(placingPos).m_60767_().m_76336_() || !((double)(i * i + j * j) < radius * radius)) continue;
                        if ((double)(i * i + j * j) > (radius - 1.0) * (radius - 1.0)) {
                            FluidState ifluidstate = world.m_6425_(placingPos);
                            if (PURPLE_PICKERELWEED.get().m_60710_((LevelReader)world, placingPos) && world.m_8055_(placingPos.m_7494_()).m_60767_().m_76336_() && world.m_213780_().m_188500_() <= 0.85) {
                                if (purple) {
                                    world.m_7731_(placingPos, (BlockState)PURPLE_PICKERELWEED.get().m_61124_((Property)PickerelweedPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_))), 2);
                                    continue;
                                }
                                world.m_7731_(placingPos, (BlockState)BLUE_PICKERELWEED.get().m_61124_((Property)PickerelweedPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_))), 2);
                                continue;
                            }
                            if (!PURPLE_PICKERELWEED.get().m_60710_((LevelReader)world, placingPos)) continue;
                            doubleplantblock.placeAt(world, placingPos, 2);
                            continue;
                        }
                        if (!doubleplantblock.m_49966_().m_60710_((LevelReader)world, placingPos)) continue;
                        doubleplantblock.placeAt(world, placingPos, 2);
                    }
                }
            }
        }
    }

    public boolean isValidBlock(LevelAccessor world, BlockPos pos) {
        return world.m_46859_(pos) || world.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public boolean shouldPlace(LevelAccessor world, BlockPos pos) {
        return world.m_6425_(pos.m_7495_().m_122024_()).m_205070_(FluidTags.f_13131_) || world.m_6425_(pos.m_7495_().m_122029_()).m_205070_(FluidTags.f_13131_) || world.m_6425_(pos.m_7495_().m_122012_()).m_205070_(FluidTags.f_13131_) || world.m_6425_(pos.m_7495_().m_122019_()).m_205070_(FluidTags.f_13131_);
    }
}

