/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block.coralstone;

import com.teamabnormals.upgrade_aquatic.common.block.coralstone.CoralstoneBlock;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;

public class CoralstoneStairsBlock
extends StairBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    @Nullable
    private final Block[] growableCoralBlocks;

    public CoralstoneStairsBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties, @Nullable Block[] growableCoralBlocks) {
        super(state, properties);
        this.growableCoralBlocks = growableCoralBlocks;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)f_56843_, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)f_56844_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, f_56841_, f_56842_, f_56843_, f_56844_});
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        if (this.growableCoralBlocks == null && state.m_60734_() != UABlocks.DEAD_CORALSTONE_STAIRS.get()) {
            CoralstoneBlock.tickConversion(UABlocks.CORALSTONE_STAIRS_CONVERSION_MAP, state, worldIn, pos, random);
        }
        if (this.growableCoralBlocks != null && random.m_188501_() < 0.24f && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.m_235672_((RandomSource)random) : Direction.m_122376_((int)(random.m_188503_(5) + 1));
            BlockPos growPos = pos.m_121945_(randDirection);
            FluidState fluidState = worldIn.m_8055_(growPos).m_60819_();
            if (randDirection.m_122411_() > 1) {
                BlockState coralState = (BlockState)this.growableCoralBlocks[2].m_49966_().m_61124_((Property)CoralWallFanBlock.f_49192_, (Comparable)randDirection);
                if (coralState.m_60710_((LevelReader)worldIn, growPos) && this.isValidPosToGrow((Level)worldIn, growPos, fluidState)) {
                    worldIn.m_7731_(growPos, coralState, 2);
                }
            } else if (randDirection.m_122411_() == 1) {
                BlockState coralState;
                BlockState blockState = coralState = random.m_188499_() ? this.growableCoralBlocks[1].m_49966_() : this.growableCoralBlocks[0].m_49966_();
                if (coralState.m_60710_((LevelReader)worldIn, growPos) && this.isValidPosToGrow((Level)worldIn, growPos, fluidState)) {
                    worldIn.m_7731_(growPos, coralState, 2);
                }
            } else {
                BlockState coralState = this.growableCoralBlocks[3].m_49966_();
                if (coralState.m_60710_((LevelReader)worldIn, growPos) && this.isValidPosToGrow((Level)worldIn, growPos, fluidState)) {
                    worldIn.m_7731_(growPos, coralState, 2);
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != worldIn.m_46753_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42574_ && state.m_60734_() != UABlocks.CORALSTONE_STAIRS.get()) {
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((Block)UABlocks.CORALSTONE_STAIRS.get()).m_49966_().m_61124_((Property)f_56841_, (Comparable)((Direction)state.m_61143_((Property)f_56841_)))).m_61124_((Property)f_56842_, (Comparable)((Half)state.m_61143_((Property)f_56842_)))).m_61124_((Property)f_56843_, (Comparable)((StairsShape)state.m_61143_((Property)f_56843_)))).m_61124_((Property)f_56844_, (Comparable)((Boolean)state.m_61143_((Property)f_56844_)));
            world.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.PLAYERS, 1.0f, 0.8f);
            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            world.m_7731_(pos, newState, 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())));
    }

    private boolean isValidPosToGrow(Level world, BlockPos pos, FluidState fluidState) {
        return world.m_8055_(pos).m_60767_().m_76336_() && fluidState.m_76186_() >= 8 && fluidState.m_205070_(FluidTags.f_13131_);
    }
}

