/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgrade_aquatic", value={Dist.CLIENT})
public class RenderOverlays {
    private static final Minecraft MC = Minecraft.m_91087_();

    @SubscribeEvent
    public static void renderOverlays(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.VIGNETTE.type()) {
            int scaledWidth = MC.m_91268_().m_85445_();
            int scaledHeight = MC.m_91268_().m_85446_();
            LocalPlayer player = RenderOverlays.MC.f_91074_;
            StatsCounter statisticsManager = player.m_108630_();
            int sleepTime = statisticsManager.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
            int configuredTime = (Integer)UAConfig.CLIENT.daysTillRenderInsomniaOverlay.get();
            float opacity = 0.0f;
            if (sleepTime == 24000 * configuredTime) {
                opacity = 0.25f;
            } else if (sleepTime == 24000 * configuredTime + 100) {
                opacity = 0.45f;
            } else if (sleepTime == 24000 * configuredTime + 200) {
                opacity = 0.65f;
            } else if (sleepTime == 24000 * configuredTime + 300) {
                opacity = 0.85f;
            } else if (sleepTime == 24000 * configuredTime + 400) {
                opacity = 0.9f;
            } else if (sleepTime >= 24000 * configuredTime + 500) {
                opacity = 1.0f;
            } else if (sleepTime < 24000 * configuredTime) {
                opacity = 0.0f;
            }
            if (RenderOverlays.MC.f_91066_.m_92176_() == CameraType.FIRST_PERSON && (Integer)UAConfig.CLIENT.daysTillRenderInsomniaOverlay.get() != 0 && RenderOverlays.MC.f_91074_.m_20193_().m_46472_() == Level.f_46428_) {
                PoseStack stack = event.getPoseStack();
                stack.m_85836_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("upgrade_aquatic", "textures/gui/overlay/insomnia.png"));
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_5483_(0.0, (double)scaledHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_((double)scaledWidth, (double)scaledHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_((double)scaledWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
                tessellator.m_85914_();
                stack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public static void renderScuteOverAir(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            int scaledWidth = MC.m_91268_().m_85445_();
            int scaledHeight = MC.m_91268_().m_85446_();
            ForgeGui forgeGui = (ForgeGui)RenderOverlays.MC.f_91065_;
            LocalPlayer player = RenderOverlays.MC.f_91074_;
            boolean inWater = player.m_204029_(FluidTags.f_13131_);
            if (inWater && forgeGui.shouldDrawSurvivalElements()) {
                ItemStack turtleHelmet = ItemStack.f_41583_;
                for (ItemStack stack : player.m_6168_()) {
                    if (stack.m_41720_() != Items.f_42354_) continue;
                    turtleHelmet = stack;
                }
                if (!turtleHelmet.m_41619_()) {
                    event.setCanceled(true);
                    PoseStack stack = event.getPoseStack();
                    stack.m_85836_();
                    RenderSystem.m_69478_();
                    int left = scaledWidth / 2 + 91;
                    int top = scaledHeight - forgeGui.rightHeight;
                    int durability = turtleHelmet.m_41773_();
                    int maxDurability = turtleHelmet.m_41776_();
                    RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("upgrade_aquatic", "textures/gui/overlay/scute_bubble_depleted.png"));
                    for (int i = 0; i < 10; ++i) {
                        int l = left - i * 8 - 9;
                        int l2 = l + 9;
                        int t = top;
                        int t2 = t + 9;
                        Tesselator tessellator = Tesselator.m_85913_();
                        BufferBuilder bufferbuilder = tessellator.m_85915_();
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                        bufferbuilder.m_5483_((double)l, (double)t2, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
                        bufferbuilder.m_5483_((double)l2, (double)t2, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
                        bufferbuilder.m_5483_((double)l2, (double)t, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
                        bufferbuilder.m_5483_((double)l, (double)t, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
                        tessellator.m_85914_();
                    }
                    RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("upgrade_aquatic", "textures/gui/overlay/scute_bubble.png"));
                    double amount = Mth.m_14008_((double)(10.0 - Math.floor((double)durability / (double)maxDurability * 10.0)), (double)1.0, (double)10.0);
                    int i = 0;
                    while ((double)i < amount) {
                        int l = left - i * 8 - 9;
                        int l2 = l + 9;
                        int t = top;
                        int t2 = t + 9;
                        Tesselator tessellator = Tesselator.m_85913_();
                        BufferBuilder bufferbuilder = tessellator.m_85915_();
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                        bufferbuilder.m_5483_((double)l, (double)t2, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
                        bufferbuilder.m_5483_((double)l2, (double)t2, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
                        bufferbuilder.m_5483_((double)l2, (double)t, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
                        bufferbuilder.m_5483_((double)l, (double)t, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
                        tessellator.m_85914_();
                        ++i;
                    }
                    forgeGui.rightHeight += 10;
                    RenderSystem.m_69461_();
                    stack.m_85849_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void removeMountMessage(CustomizeGuiOverlayEvent.DebugText event) {
        if (RenderOverlays.MC.f_91074_.m_20159_() && RenderOverlays.MC.f_91074_.m_20202_() instanceof Thrasher && RenderOverlays.MC.f_91065_.f_92990_.getString().equals(I18n.m_118938_((String)"mount.onboard", (Object[])new Object[]{I18n.m_118938_((String)"key.keyboard.left.shift", (Object[])new Object[0])}))) {
            RenderOverlays.MC.f_91065_.m_93063_((Component)Component.m_237113_((String)""), false);
        }
    }
}

