/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.AetherBookCategory;
import com.aetherteam.aether.recipe.recipes.item.AbstractAetherCookingRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AetherCookingSerializer<T extends AbstractAetherCookingRecipe>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final CookieBaker<T> factory;

    public AetherCookingSerializer(CookieBaker<T> factory, int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        ItemStack result;
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        AetherBookCategory aetherBookCategory = (AetherBookCategory)AetherBookCategory.CODEC.m_216455_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)AetherBookCategory.UNKNOWN.name()));
        JsonArray ingredientJson = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        } else {
            String resultString = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            ResourceLocation resultLocation = new ResourceLocation(resultString);
            result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resultLocation));
            if (result.m_41619_()) {
                throw new IllegalStateException("Item: " + resultString + " does not exist");
            }
        }
        float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(id, group, aetherBookCategory, ingredient, result, experience, cookingTime);
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        AetherBookCategory aetherBookCategory = (AetherBookCategory)buffer.m_130066_(AetherBookCategory.class);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        float experience = buffer.readFloat();
        int cookingTime = buffer.m_130242_();
        return this.factory.create(id, group, aetherBookCategory, ingredient, result, experience, cookingTime);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(recipe.m_6076_());
        buffer.m_130068_((Enum)Objects.requireNonNullElse(((AbstractAetherCookingRecipe)((Object)recipe)).aetherCategory(), AetherBookCategory.UNKNOWN));
        ((Ingredient)recipe.m_7527_().get(0)).m_43923_(buffer);
        buffer.m_130055_(((AbstractAetherCookingRecipe)((Object)recipe)).getResult());
        buffer.writeFloat(recipe.m_43750_());
        buffer.m_130130_(recipe.m_43753_());
    }

    public static interface CookieBaker<T extends AbstractAetherCookingRecipe> {
        public T create(ResourceLocation var1, String var2, AetherBookCategory var3, Ingredient var4, ItemStack var5, float var6, int var7);
    }
}

