/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractCrystal
extends Projectile {
    protected int ticksInAir = 0;

    protected AbstractCrystal(EntityType<? extends AbstractCrystal> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir > this.getLifeSpan() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        HitResult result = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        boolean flag = false;
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)result).m_82425_();
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            if (blockState.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockPos);
                flag = true;
            } else if (blockState.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
                if (blockEntity instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity endGatewayBlockEntity = (TheEndGatewayBlockEntity)blockEntity;
                    if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)blockPos, (BlockState)blockState, (Entity)this, (TheEndGatewayBlockEntity)endGatewayBlockEntity);
                    }
                }
                flag = true;
            }
        }
        if (result.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)) {
            this.m_6532_(result);
        }
        this.m_20101_();
        this.tickMovement();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.spawnExplosionParticles();
        super.m_142687_(reason);
    }

    protected void tickMovement() {
        Vec3 vector3d = this.m_20184_();
        double d2 = this.m_20185_() + vector3d.m_7096_();
        double d0 = this.m_20186_() + vector3d.m_7098_();
        double d1 = this.m_20189_() + vector3d.m_7094_();
        this.m_37283_();
        this.m_6034_(d2, d0, d1);
    }

    public void spawnExplosionParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int i = 0; i < 20; ++i) {
                double x = (double)(this.f_19796_.m_188501_() - 0.5f) * 0.5;
                double y = (double)(this.f_19796_.m_188501_() - 0.5f) * 0.5;
                double z = (double)(this.f_19796_.m_188501_() - 0.5f) * 0.5;
                level2.m_8767_(this.getExplosionParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, x, y, z, 0.0);
            }
        }
    }

    protected abstract ParticleOptions getExplosionParticle();

    @Nullable
    protected SoundEvent getImpactExplosionSoundEvent() {
        return null;
    }

    public int getLifeSpan() {
        return 300;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TicksInAir", this.ticksInAir);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("TicksInAir")) {
            this.ticksInAir = tag.m_128451_("TicksInAir");
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

