/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.ai.controller.BlankMoveControl;
import com.aetherteam.aether.entity.ai.goal.MostDamageTargetGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.AvoidObstaclesGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.BackOffAfterAttackGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.CollideGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.CrushGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.SetPathUpOrDownGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.SliderMoveGoal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

public class Slider
extends PathfinderMob
implements AetherBossMob<Slider>,
Enemy,
IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> DATA_AWAKE_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Component> DATA_BOSS_NAME_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private static final EntityDataAccessor<Float> DATA_HURT_ANGLE_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_HURT_ANGLE_X_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_HURT_ANGLE_Z_ID = SynchedEntityData.m_135353_(Slider.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Music SLIDER_MUSIC = new Music((SoundEvent)AetherSoundEvents.MUSIC_BOSS_SLIDER.get(), 0, 0, true);
    public static final Map<Block, Function<BlockState, BlockState>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<Block, Function<BlockState, BlockState>>(Map.ofEntries(Map.entry((Block)AetherBlocks.LOCKED_CARVED_STONE.get(), blockState -> ((Block)AetherBlocks.CARVED_STONE.get()).m_49966_()), Map.entry((Block)AetherBlocks.LOCKED_SENTRY_STONE.get(), blockState -> ((Block)AetherBlocks.SENTRY_STONE.get()).m_49966_()), Map.entry((Block)AetherBlocks.BOSS_DOORWAY_CARVED_STONE.get(), blockState -> Blocks.f_50016_.m_49966_()), Map.entry((Block)AetherBlocks.TREASURE_DOORWAY_CARVED_STONE.get(), blockState -> (BlockState)((TrapDoorBlock)AetherBlocks.SKYROOT_TRAPDOOR.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))))));
    private MostDamageTargetGoal mostDamageTargetGoal;
    private final ServerBossEvent bossFight;
    @Nullable
    private BossRoomTracker<Slider> bronzeDungeon;
    private int chatCooldown;
    private Direction moveDirection = null;
    private int moveDelay = this.calculateMoveDelay();
    private Vec3 targetPoint = null;
    private int attackCooldown = 0;

    public Slider(EntityType<? extends Slider> type, Level level) {
        super(type, level);
        this.f_21342_ = new BlankMoveControl((Mob)this);
        this.bossFight = (ServerBossEvent)new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true);
        this.setBossFight(false);
        this.f_21364_ = 50;
        this.m_19915_(0.0f, 0.0f);
        this.m_21530_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setBossName((Component)BossNameGenerator.generateSliderName(this.m_217043_()));
        this.m_6027_(Mth.m_14107_((double)this.m_20185_()), this.m_20186_(), Mth.m_14107_((double)this.m_20189_()));
        return spawnData;
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CollideGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CrushGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BackOffAfterAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SetPathUpOrDownGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AvoidObstaclesGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SliderMoveGoal(this));
        this.mostDamageTargetGoal = new MostDamageTargetGoal((Mob)this);
        this.f_21346_.m_25352_(1, (Goal)this.mostDamageTargetGoal);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_AWAKE_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_BOSS_NAME_ID, (Object)Component.m_237113_((String)"Slider"));
        this.m_20088_().m_135372_(DATA_HURT_ANGLE_ID, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(DATA_HURT_ANGLE_X_ID, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(DATA_HURT_ANGLE_Z_ID, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.isAwake() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            this.m_6710_(null);
        }
        this.evaporate();
        if (this.getChatCooldown() > 0) {
            --this.chatCooldown;
        }
    }

    private void evaporate() {
        Pair minMax = this.getDefaultBounds((Mob)this);
        AetherBossMob.super.evaporate(this, (BlockPos)minMax.getLeft(), (BlockPos)minMax.getRight(), blockState -> true);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
        if (this.moveDelay > 0) {
            --this.moveDelay;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.m_5448_() != null && this.m_5448_().m_21224_()) {
            this.m_6710_(null);
            this.setTargetPoint(null);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Optional<LivingEntity> damageResult = this.canDamageSlider(source);
        if (source.m_19378_()) {
            Entity entity;
            super.m_6469_(source, amount);
            if (!this.m_9236_().m_5776_() && (entity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.mostDamageTargetGoal.addAggro(living, amount);
            }
        } else if (damageResult.isPresent()) {
            LivingEntity attacker = damageResult.get();
            if (super.m_6469_(source, amount) && this.m_21223_() > 0.0f) {
                Entity entity;
                if (!this.isBossFight()) {
                    this.start();
                }
                this.m_20256_(this.m_20184_().m_82490_(0.75));
                double a = Math.abs(this.m_20182_().m_7096_() - attacker.m_20182_().m_7096_());
                double c = Math.abs(this.m_20182_().m_7094_() - attacker.m_20182_().m_7094_());
                if (a > c) {
                    this.setHurtAngleZ(1.0f);
                    this.setHurtAngleX(0.0f);
                    if (this.m_20182_().m_7096_() > attacker.m_20182_().m_7096_()) {
                        this.setHurtAngleZ(-1.0f);
                    }
                } else {
                    this.setHurtAngleX(1.0f);
                    this.setHurtAngleZ(0.0f);
                    if (this.m_20182_().m_7094_() > attacker.m_20182_().m_7094_()) {
                        this.setHurtAngleX(-1.0f);
                    }
                }
                this.setHurtAngle(0.7f - this.m_21223_() / 875.0f);
                if (!this.m_9236_().m_5776_() && (entity = source.m_7639_()) instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    this.mostDamageTargetGoal.addAggro(living, amount);
                }
                return true;
            }
        }
        return false;
    }

    private Optional<LivingEntity> canDamageSlider(DamageSource source) {
        if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
            Entity entity = source.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                    if (attacker.m_21205_().canPerformAction(ToolActions.PICKAXE_DIG) || attacker.m_21205_().m_204117_(AetherTags.Items.SLIDER_DAMAGING_ITEMS) || attacker.m_21205_().m_41735_(((Block)AetherBlocks.CARVED_STONE.get()).m_49966_())) {
                        return Optional.of(attacker);
                    }
                    return this.sendInvalidToolMessage(attacker);
                }
                this.sendTooFarMessage(attacker);
            } else {
                Projectile projectile;
                Entity entity2;
                entity = source.m_7640_();
                if (entity instanceof Projectile && (entity2 = (projectile = (Projectile)entity).m_37282_()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity2;
                    if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                        if (projectile.m_6095_().m_204039_(AetherTags.Entities.SLIDER_DAMAGING_PROJECTILES)) {
                            return Optional.of(attacker);
                        }
                        return this.sendInvalidToolMessage(attacker);
                    }
                    return this.sendTooFarMessage(attacker);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<LivingEntity> sendInvalidToolMessage(LivingEntity attacker) {
        if (!this.m_9236_().m_5776_() && attacker instanceof Player) {
            Player player = (Player)attacker;
            if (this.getChatCooldown() <= 0) {
                if (((Boolean)AetherConfig.COMMON.reposition_slider_message.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"gui.aether.slider.message.attack.invalid"), true);
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"gui.aether.slider.message.attack.invalid"));
                }
                this.setChatCooldown(15);
            }
        }
        return Optional.empty();
    }

    private Optional<LivingEntity> sendTooFarMessage(LivingEntity attacker) {
        if (!this.m_9236_().m_5776_() && attacker instanceof Player) {
            Player player = (Player)attacker;
            if (this.getChatCooldown() <= 0) {
                this.displayTooFarMessage(player);
                this.setChatCooldown(15);
            }
        }
        return Optional.empty();
    }

    private void start() {
        if (this.getAwakenSound() != null) {
            this.m_5496_(this.getAwakenSound(), 2.5f, 1.0f / (this.m_217043_().m_188501_() * 0.2f + 0.9f));
        }
        this.m_21153_(this.m_21233_());
        this.setAwake(true);
        this.setBossFight(true);
        if (this.getDungeon() != null) {
            this.closeRoom();
        }
        AetherEventDispatch.onBossFightStart((Entity)this, this.getDungeon());
    }

    public void reset() {
        this.m_20256_(Vec3.f_82478_);
        this.setAwake(false);
        this.setBossFight(false);
        this.m_6710_(null);
        if (this.getDungeon() != null) {
            this.m_146884_(this.getDungeon().originCoordinates());
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((Entity)this, this.getDungeon());
    }

    public void m_6667_(DamageSource source) {
        this.m_20256_(Vec3.f_82478_);
        this.explode();
        if (this.m_9236_() instanceof ServerLevel) {
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.m_6667_(source);
    }

    private void explode() {
        for (int i = 0; i < (this.m_21223_() <= 0.0f ? 16 : 48); ++i) {
            double x = this.m_20182_().m_7096_() + (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 1.5;
            double y = this.m_20191_().f_82289_ + 1.75 + (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 1.5;
            double z = this.m_20182_().m_7094_() + (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 1.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public void m_6043_() {
    }

    @Nullable
    public BlockState convertBlock(BlockState state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.m_60734_(), blockState -> null).apply(state);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Display(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.m_6543_(player);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Remove(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        this.bossFight.m_6539_(player);
        AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), player);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), serverPlayer);
        }
    }

    public boolean isAwake() {
        return (Boolean)this.m_20088_().m_135370_(DATA_AWAKE_ID);
    }

    public void setAwake(boolean awake) {
        this.m_20088_().m_135381_(DATA_AWAKE_ID, (Object)awake);
    }

    public Component getBossName() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        if (!((Boolean)AetherConfig.COMMON.randomize_boss_names.get()).booleanValue()) {
            return Component.m_237115_((String)"entity.aether.slider");
        }
        return (Component)this.m_20088_().m_135370_(DATA_BOSS_NAME_ID);
    }

    public void setBossName(Component component) {
        this.m_20088_().m_135381_(DATA_BOSS_NAME_ID, (Object)component);
        this.bossFight.m_6456_(component);
    }

    public float getHurtAngleX() {
        return ((Float)this.m_20088_().m_135370_(DATA_HURT_ANGLE_X_ID)).floatValue();
    }

    public void setHurtAngleX(float hurtAngleX) {
        this.m_20088_().m_135381_(DATA_HURT_ANGLE_X_ID, (Object)Float.valueOf(hurtAngleX));
    }

    public float getHurtAngleZ() {
        return ((Float)this.m_20088_().m_135370_(DATA_HURT_ANGLE_Z_ID)).floatValue();
    }

    public void setHurtAngleZ(float hurtAngleZ) {
        this.m_20088_().m_135381_(DATA_HURT_ANGLE_Z_ID, (Object)Float.valueOf(hurtAngleZ));
    }

    public float getHurtAngle() {
        return ((Float)this.m_20088_().m_135370_(DATA_HURT_ANGLE_ID)).floatValue();
    }

    public void setHurtAngle(float hurtAngle) {
        this.m_20088_().m_135381_(DATA_HURT_ANGLE_ID, (Object)Float.valueOf(hurtAngle));
    }

    @Nullable
    public BossRoomTracker<Slider> getDungeon() {
        return this.bronzeDungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<Slider> dungeon) {
        this.bronzeDungeon = dungeon;
    }

    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    @Override
    @Nullable
    public ResourceLocation getBossBarTexture() {
        return new ResourceLocation("aether", "textures/gui/boss_bar_slider.png");
    }

    @Override
    @Nullable
    public Music getBossMusic() {
        return SLIDER_MUSIC;
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int cooldown) {
        this.chatCooldown = cooldown;
    }

    public int getDeathScore() {
        return this.f_20897_;
    }

    @Nullable
    public Direction getMoveDirection() {
        return this.moveDirection;
    }

    public void setMoveDirection(@Nullable Direction moveDirection) {
        this.moveDirection = moveDirection;
    }

    public int getMoveDelay() {
        return this.moveDelay;
    }

    public void setMoveDelay(int moveDelay) {
        this.moveDelay = moveDelay;
    }

    @Nullable
    public Vec3 findTargetPoint() {
        Vec3 pos = this.targetPoint;
        if (pos != null) {
            return pos;
        }
        LivingEntity target = this.m_5448_();
        return target == null ? null : target.m_20182_();
    }

    @Nullable
    public Vec3 getTargetPoint() {
        return this.targetPoint;
    }

    public void setTargetPoint(@Nullable Vec3 targetPoint) {
        this.targetPoint = targetPoint;
    }

    public int attackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public int calculateMoveDelay() {
        return this.isCritical() ? 1 + this.m_217043_().m_188503_(10) : 2 + this.m_217043_().m_188503_(14);
    }

    public static Direction calculateDirection(double x, double y, double z) {
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        if (absY > absX && absY > absZ) {
            return y > 0.0 ? Direction.UP : Direction.DOWN;
        }
        if (absX > absZ) {
            return x > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return z > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static AABB calculateAdjacentBox(AABB box, Direction direction) {
        double minX = box.f_82288_;
        double minY = box.f_82289_;
        double minZ = box.f_82290_;
        double maxX = box.f_82291_;
        double maxY = box.f_82292_;
        double maxZ = box.f_82293_;
        if (direction == Direction.UP) {
            minY = maxY;
            maxY += 1.0;
        } else if (direction == Direction.DOWN) {
            maxY = minY;
            minY -= 1.0;
        } else if (direction == Direction.NORTH) {
            maxZ = minZ;
            minZ -= 1.0;
        } else if (direction == Direction.SOUTH) {
            minZ = maxZ;
            maxZ += 1.0;
        } else if (direction == Direction.EAST) {
            minX = maxX;
            maxX += 1.0;
        } else {
            maxX = minX;
            minX -= 1.0;
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public float getVelocityIncrease() {
        return this.isCritical() ? 0.045f - this.m_21223_() / 10000.0f : 0.035f - this.m_21223_() / 30000.0f;
    }

    public boolean isCritical() {
        return this.m_21223_() <= 100.0f;
    }

    public float getMaxVelocity() {
        return 2.5f;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.setBossName(name);
    }

    protected SoundEvent getAwakenSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_AWAKEN.get();
    }

    public SoundEvent getCollideSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_COLLIDE.get();
    }

    public SoundEvent getMoveSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_MOVE.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_DEATH.get();
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_();
    }

    public boolean m_6128_() {
        return true;
    }

    public float m_146908_() {
        return 0.0f;
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_5829_() {
        return !this.isAwake();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_147223_() {
        return true;
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_146890_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.addBossSaveData(tag);
        tag.m_128379_("Awake", this.isAwake());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readBossSaveData(tag);
        if (tag.m_128441_("Awake")) {
            this.setAwake(tag.m_128471_("Awake"));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

