/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.ai.goal.MostDamageTargetGoal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.ValkyrieTeleportEvent;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public abstract class AbstractValkyrie
extends Monster
implements NotGrounded {
    private static final EntityDataAccessor<Boolean> DATA_ENTITY_ON_GROUND_ID = SynchedEntityData.m_135353_(AbstractValkyrie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private MostDamageTargetGoal mostDamageTargetGoal;
    private int lungeCooldown = 0;
    protected double lastMotionY;

    public AbstractValkyrie(EntityType<? extends AbstractValkyrie> type, Level level) {
        super(type, level);
        this.f_21342_ = new ValkyrieMoveControl((Mob)this);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ValkyrieTeleportGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.65, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 8.0f));
        this.mostDamageTargetGoal = new MostDamageTargetGoal((Mob)this);
        this.f_21346_.m_25352_(1, (Goal)this.mostDamageTargetGoal);
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ENTITY_ON_GROUND_ID, (Object)true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_()) {
            this.setEntityOnGround(true);
        }
        if (!this.m_9236_().m_5776_() && this.lungeCooldown > 0) {
            --this.lungeCooldown;
        }
    }

    public void m_7023_(Vec3 motion) {
        this.lastMotionY = this.m_20184_().m_7098_();
        this.f_20887_ = this.m_6113_() * 0.216f;
        super.m_7023_(motion);
    }

    protected void m_6135_() {
        super.m_6135_();
        this.setEntityOnGround(false);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        boolean result = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && result && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.mostDamageTargetGoal.addAggro(living, amount);
        }
        return result;
    }

    protected boolean teleportAroundTarget(Entity target) {
        Vec2 targetVec = new Vec2(this.m_217043_().m_188501_() - 0.5f, this.m_217043_().m_188501_() - 0.5f).m_165902_();
        double x = target.m_20185_() + (double)(targetVec.f_82470_ * 3.0f);
        double y = target.m_20186_();
        double z = target.m_20189_() + (double)(targetVec.f_82471_ * 3.0f);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        for (int i = 0; mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60767_().m_76334_() && i <= 4; ++i) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        boolean isValidSpot = blockState.m_204336_(AetherTags.Blocks.VALKYRIE_TELEPORTABLE_ON);
        return isValidSpot && this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        ValkyrieTeleportEvent event = AetherEventDispatch.onValkyrieTeleport((LivingEntity)this, x, y, z);
        if (event.isCanceled()) {
            return false;
        }
        boolean flag = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (flag) {
            this.spawnExplosionParticles();
        }
        return flag;
    }

    public void spawnExplosionParticles() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)70);
        }
    }

    protected void chat(Player player, Component message, boolean sound) {
        player.m_213846_(message);
    }

    @Override
    public boolean isEntityOnGround() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ENTITY_ON_GROUND_ID);
    }

    @Override
    public void setEntityOnGround(boolean onGround) {
        this.m_20088_().m_135381_(DATA_ENTITY_ON_GROUND_ID, (Object)onGround);
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            for (int i = 0; i < 5; ++i) {
                EntityUtil.spawnMovementExplosionParticles((Entity)this);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public static class ValkyrieMoveControl
    extends MoveControl {
        public ValkyrieMoveControl(Mob pMob) {
            super(pMob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.JUMPING) {
                this.f_24981_ = MoveControl.Operation.MOVE_TO;
            }
            super.m_8126_();
        }
    }

    public static class ValkyrieTeleportGoal
    extends Goal {
        private final AbstractValkyrie valkyrie;
        protected int teleportTimer;

        public ValkyrieTeleportGoal(AbstractValkyrie valkyrie) {
            this.valkyrie = valkyrie;
            this.teleportTimer = this.valkyrie.m_217043_().m_188503_(200);
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.teleportTimer++ < 450) {
                return;
            }
            this.teleportTimer = this.valkyrie.m_5448_() != null && this.valkyrie.teleportAroundTarget((Entity)this.valkyrie.m_5448_()) ? this.valkyrie.m_217043_().m_188503_(40) : (this.teleportTimer -= 20);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class LungeGoal
    extends Goal {
        private final AbstractValkyrie valkyrie;
        private final double speedModifier;
        private int flyingTicks;
        private int lungeCooldownMax;

        public LungeGoal(AbstractValkyrie valkyrie, double speedModifier, int lungeCooldownMax) {
            this.valkyrie = valkyrie;
            this.speedModifier = speedModifier;
            this.lungeCooldownMax = lungeCooldownMax;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.valkyrie.m_20096_() && this.valkyrie.lungeCooldown <= 0;
        }

        public void m_8037_() {
            LivingEntity target = this.valkyrie.m_5448_();
            double motionY = this.valkyrie.m_20184_().m_7098_();
            if (target != null) {
                if (motionY < 0.2 && this.valkyrie.lastMotionY >= 0.2 && this.valkyrie.m_20270_((Entity)target) <= 16.0f) {
                    double x = target.m_20185_() - this.valkyrie.m_20185_();
                    double z = target.m_20189_() - this.valkyrie.m_20189_();
                    double angle = Math.atan2(x, z);
                    this.valkyrie.m_20334_(Math.sin(angle) * 0.3, motionY -= 0.1, Math.cos(angle) * 0.3);
                    this.valkyrie.m_146922_((float)angle * 57.295776f);
                    this.flyingTicks = 8;
                }
                if (this.flyingTicks > 0) {
                    --this.flyingTicks;
                    AttributeInstance gravity = this.valkyrie.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                    double fallSpeed = gravity != null ? Math.max(gravity.m_22135_() * -0.625, -0.275) : -0.275;
                    if (motionY < fallSpeed) {
                        this.valkyrie.m_20334_(this.valkyrie.m_20184_().m_7096_(), fallSpeed, this.valkyrie.m_20184_().m_7094_());
                        this.valkyrie.setEntityOnGround(false);
                    }
                }
                Vec3 position = target.m_20182_();
                this.valkyrie.m_21566_().m_6849_(position.m_7096_(), position.m_7098_(), position.m_7094_(), this.speedModifier);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            this.valkyrie.lungeCooldown = this.lungeCooldownMax;
        }
    }
}

