/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractWhirlwind
extends Mob {
    public static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.m_135353_(AbstractWhirlwind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lifeLeft;
    private int dropsTimer;
    private int stuckTick;
    private float movementAngle;
    private float movementCurve;
    private boolean isEvil = false;

    public AbstractWhirlwind(EntityType<? extends AbstractWhirlwind> type, Level level) {
        super(type, level);
        if (level.m_5776_()) {
            this.movementAngle = this.m_217043_().m_188501_() * 360.0f;
            this.movementCurve = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.1f;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MoveGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.025).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_COLOR_ID, (Object)this.getDefaultColor());
    }

    public static boolean checkWhirlwindSpawnRules(EntityType<? extends AbstractWhirlwind> whirlwind, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(whirlwind, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && level.m_45524_(pos, 0) > 12 && level.m_46791_() != Difficulty.PEACEFUL;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lifeLeft;
        if (!this.m_9236_().m_5776_() && (this.lifeLeft <= 0 || this.isInFluidType())) {
            this.m_146870_();
        }
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19863_ && !this.f_201939_) {
                this.stuckTick += 4;
            } else if (this.stuckTick > 0) {
                --this.stuckTick;
            }
            if (this.m_5448_() != null) {
                ++this.dropsTimer;
            }
            if (this.dropsTimer >= 128) {
                this.spawnDrops();
                this.dropsTimer = 0;
            }
        } else {
            this.spawnParticles();
        }
        super.m_8107_();
        List<Entity> entityList = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(2.5, 2.5, 2.5)).stream().filter(entity -> !entity.m_6095_().m_204039_(AetherTags.Entities.WHIRLWIND_UNAFFECTED)).toList();
        for (Entity entity2 : entityList) {
            double d1;
            double x = (float)entity2.m_20185_();
            double y = (double)((float)entity2.m_20186_()) - entity2.m_6049_() * (double)0.6f;
            double z = (float)entity2.m_20189_();
            double distance = this.m_20270_(entity2);
            if (distance <= 1.5 + (d1 = y - this.m_20186_())) {
                entity2.m_20334_(entity2.m_20184_().m_7096_(), 0.15, entity2.m_20184_().m_7094_());
                entity2.m_183634_();
                if (d1 > 1.5) {
                    entity2.m_20334_(entity2.m_20184_().m_7096_(), -0.45 + d1 * 0.35, entity2.m_20184_().m_7094_());
                    distance += d1 * 1.5;
                } else {
                    entity2.m_20334_(entity2.m_20184_().m_7096_(), 0.125, entity2.m_20184_().m_7094_());
                }
                double d2 = Math.atan2(this.m_20185_() - x, this.m_20189_() - z) / 0.0175;
                entity2.m_20334_(-Math.cos(0.0175 * (d2 += 160.0)) * (distance + 0.25) * 0.1, entity2.m_20184_().f_82480_, Math.sin(0.0175 * d2) * (distance + 0.25) * 0.1);
                if (entity2 instanceof AbstractWhirlwind) {
                    entity2.m_146870_();
                }
            } else {
                double d3 = Math.atan2(this.m_20185_() - x, this.m_20189_() - z) / 0.0175;
                entity2.m_20256_(entity2.m_20184_().m_82520_(Math.sin(0.0175 * d3) * 0.01, entity2.m_20184_().f_82480_, Math.cos(0.0175 * d3) * 0.01));
            }
            if (this.m_9236_().m_46859_(this.m_20183_())) continue;
            this.lifeLeft -= 50;
        }
        if (this.stuckTick > 40) {
            this.lifeLeft = 0;
        }
    }

    protected void spawnDrops() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_217043_().m_188503_(4) == 0) {
                LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)this);
                LootTable lootTable = serverLevel.m_7654_().m_129898_().m_79217_(this.getLootLocation());
                ObjectArrayList list = lootTable.m_230922_(builder.m_78975_(LootContextParamSets.f_81413_));
                for (ItemStack itemstack : list) {
                    serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)AetherSoundEvents.ENTITY_WHIRLWIND_DROP.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
                    this.m_5552_(itemstack, 1.0f);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return false;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    public abstract void spawnParticles();

    public abstract ResourceLocation getLootLocation();

    public int getColorData() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR_ID);
    }

    public void setColorData(int color) {
        this.m_20088_().m_135381_(DATA_COLOR_ID, (Object)color);
    }

    public int getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(int lifeLeft) {
        this.lifeLeft = lifeLeft;
    }

    public boolean isEvil() {
        return this.isEvil;
    }

    public void setEvil(boolean evil) {
        this.isEvil = evil;
    }

    public abstract int getDefaultColor();

    public boolean m_6147_() {
        return this.f_19862_;
    }

    public int m_5792_() {
        return 1;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Movement Angle", this.movementAngle);
        tag.m_128350_("Movement Curve", this.movementCurve);
        tag.m_128405_("Life Left", this.lifeLeft);
        tag.m_128405_("Color", this.getColorData());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Movement Angle")) {
            this.movementAngle = tag.m_128457_("Movement Angle");
        }
        if (tag.m_128441_("Movement Curve")) {
            this.movementCurve = tag.m_128457_("Movement Curve");
        }
        if (tag.m_128441_("Life Left")) {
            this.lifeLeft = tag.m_128451_("Life Left");
        }
        if (tag.m_128441_("Color")) {
            this.setColorData(tag.m_128451_("Color"));
        }
    }

    protected static class MoveGoal
    extends Goal {
        private final AbstractWhirlwind whirlwind;
        protected float movementAngle;
        protected float movementCurve;

        public MoveGoal(AbstractWhirlwind entity) {
            this.whirlwind = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.movementAngle == 0.0f) {
                this.movementAngle = this.whirlwind.movementAngle;
                this.movementCurve = this.whirlwind.movementCurve;
            }
            if (!this.whirlwind.isEvil || this.whirlwind.m_5448_() == null) {
                BlockPos offset = new BlockPos(this.whirlwind.m_20182_().m_82549_(this.whirlwind.m_20184_()));
                this.movementAngle = this.whirlwind.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, offset.m_123341_(), offset.m_123343_()) < offset.m_123342_() - this.whirlwind.m_6056_() ? (this.movementAngle += 180.0f) : (this.movementAngle += this.movementCurve);
                double modifier = 1.0;
                AttributeInstance speed = this.whirlwind.m_21051_(Attributes.f_22279_);
                if (speed != null) {
                    modifier = speed.m_22135_();
                }
                this.whirlwind.m_20334_(Math.cos(this.movementAngle * ((float)Math.PI / 180)) * modifier, this.whirlwind.m_20184_().f_82480_, Math.sin(this.movementAngle * ((float)Math.PI / 180)) * modifier);
            } else {
                this.whirlwind.m_20256_(Vec3.f_82478_);
            }
        }
    }
}

