/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.entity.projectile.dart.AbstractDart;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DartLayer<T extends LivingEntity, M extends PlayerModel<T>>
extends StuckInBodyLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;
    private final Function<Entity, AbstractDart> dart;
    private final Function<AetherPlayer, Integer> dartCount;
    private final float offset;

    public DartLayer(EntityRenderDispatcher renderDispatcher, LivingEntityRenderer<T, M> renderer, Function<Entity, AbstractDart> dart, Function<AetherPlayer, Integer> dartCount, float offset) {
        super(renderer);
        this.dispatcher = renderDispatcher;
        this.dart = dart;
        this.dartCount = dartCount;
        this.offset = offset;
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int i = this.m_7040_(livingEntity);
        float offset = this.offset;
        RandomSource randomSource = RandomSource.m_216335_((long)((long)((double)livingEntity.m_19879_() * (0.25 * (double)offset))));
        if (i > 0) {
            for (int j = 0; j < i; ++j) {
                poseStack.m_85836_();
                ModelPart modelPart = ((PlayerModel)this.m_117386_()).m_233438_(randomSource);
                ModelPart.Cube cube = modelPart.m_233558_(randomSource);
                modelPart.m_104299_(poseStack);
                float f = randomSource.m_188501_();
                float f1 = randomSource.m_188501_();
                float f2 = randomSource.m_188501_();
                float f3 = Mth.m_14179_((float)f, (float)cube.f_104335_, (float)cube.f_104338_) / 16.0f;
                float f4 = Mth.m_14179_((float)f1, (float)cube.f_104336_, (float)cube.f_104339_) / 16.0f;
                float f5 = Mth.m_14179_((float)f2, (float)cube.f_104337_, (float)cube.f_104340_) / 16.0f;
                poseStack.m_85837_((double)f3, (double)f4, (double)f5);
                f = -1.0f * (f * 2.0f - 1.0f);
                f1 = -1.0f * (f1 * 2.0f - 1.0f);
                f2 = -1.0f * (f2 * 2.0f - 1.0f);
                this.m_5558_(poseStack, buffer, packedLight, (Entity)livingEntity, f, f1, f2, partialTicks);
                poseStack.m_85849_();
            }
        }
    }

    protected void m_5558_(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, float x, float y, float z, float partialTick) {
        float f = Mth.m_14116_((float)(x * x + z * z));
        AbstractDart dart = this.dart.apply(entity);
        dart.m_146884_(entity.m_20182_());
        dart.m_146922_((float)(Math.atan2(x, z) * 57.2957763671875));
        dart.m_146926_((float)(Math.atan2(y, f) * 57.2957763671875));
        dart.f_19859_ = dart.m_146908_();
        dart.f_19860_ = dart.m_146909_();
        this.dispatcher.m_114384_((Entity)dart, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packedLight);
    }

    protected int m_7040_(T entity) {
        Player player;
        Optional aetherPlayerOptional;
        if (entity instanceof Player && (aetherPlayerOptional = AetherPlayer.get(player = (Player)entity).resolve()).isPresent()) {
            return this.dartCount.apply((AetherPlayer)aetherPlayerOptional.get());
        }
        return 0;
    }
}

