/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.arrow;

import com.aetherteam.aether.capability.arrow.PhoenixArrow;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.PhoenixArrowSyncPacket;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Triple;

public class PhoenixArrowCapability
implements PhoenixArrow {
    private final AbstractArrow arrow;
    private boolean isPhoenixArrow;
    private int fireTime;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setPhoenixArrow", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setPhoenixArrow((Boolean)object), this::isPhoenixArrow)));

    public PhoenixArrowCapability(AbstractArrow arrow) {
        this.arrow = arrow;
    }

    @Override
    public AbstractArrow getArrow() {
        return this.arrow;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("PhoenixArrow", this.isPhoenixArrow());
        tag.m_128405_("FireTime", this.getFireTime());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("PhoenixArrow")) {
            this.setPhoenixArrow(tag.m_128471_("PhoenixArrow"));
        }
        if (tag.m_128441_("FireTime")) {
            this.setFireTime(tag.m_128451_("FireTime"));
        }
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    @Override
    public void setPhoenixArrow(boolean isPhoenixArrow) {
        this.isPhoenixArrow = isPhoenixArrow;
    }

    @Override
    public boolean isPhoenixArrow() {
        return this.isPhoenixArrow;
    }

    @Override
    public void setFireTime(int time) {
        this.fireTime = time;
    }

    @Override
    public int getFireTime() {
        return this.fireTime;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new PhoenixArrowSyncPacket(this.getArrow().m_19879_(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return AetherPacketHandler.INSTANCE;
    }
}

