/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.LootTableAlias;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class ChestHandler
extends ProbabilityDataHandler<ChestHandler> {
    private static final DataParser PARSER = DataParser.of(DataHandlerType.CHEST, parser -> {
        parser.add("loot", BuiltInLootTables.f_78742_).setSuggestions(LootTableAlias.REGISTRY::getKeys, ResourceLocation::toString);
        parser.add("chest", Blocks.f_50087_.m_49966_()).setDefaultValName("minecraft:chest");
        parser.add("generation_chance", 1.0f, 0.0f, 1.0f);
    });
    private final ResourceLocation lootTable;
    private final BlockState chest;

    public ChestHandler(DataMap data) {
        super(data, "generation_chance");
        this.lootTable = data.get("loot", ResourceLocation.class);
        this.chest = data.get("chest", BlockState.class);
    }

    public static DataParser parser() {
        return PARSER;
    }

    @Override
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
        BlockState chest = this.createState(dataHandler, this.chest);
        ResourceLocation loot = LootTableAlias.getLootTable(this.lootTable);
        try {
            this.createChest(piece, (ServerLevelAccessor)level, bounds, rand, pos, loot, chest);
        }
        catch (Exception e) {
            level.m_7731_(pos, chest, 2);
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof RandomizableContainerBlockEntity) {
            ((RandomizableContainerBlockEntity)blockentity).m_59626_(loot, rand.m_188505_());
        }
    }
}

