/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.cable.ContainerCable;
import com.lothrazar.storagenetwork.block.cable.export.ContainerCableExportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.ContainerCableImportFilter;
import com.lothrazar.storagenetwork.block.collection.ContainerCollectionFilter;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.network.RefreshFilterClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CableIOMessage {
    private boolean isAllowlist;
    private final int id;
    private int value = 0;
    private ItemStack stack = ItemStack.f_41583_;

    public CableIOMessage(int id) {
        this.id = id;
    }

    public CableIOMessage(int id, int value, boolean isall) {
        this(id);
        this.value = value;
        this.isAllowlist = isall;
    }

    public CableIOMessage(int id, int value, ItemStack stackin) {
        this(id);
        this.value = value;
        this.stack = stackin;
    }

    public CableIOMessage(int id, ItemStack s) {
        this(id);
        this.stack = s;
    }

    public String toString() {
        return "CableDataMessage{isAllowlist=" + this.isAllowlist + ", id=" + this.id + ", value=" + this.value + ", stack=" + this.stack + "}";
    }

    public static void handle(CableIOMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CableIOMessage.handleInternal(message, ctx));
        ctx.get().setPacketHandled(true);
    }

    private static void handleInternal(CableIOMessage message, Supplier<NetworkEvent.Context> ctx) {
        ContainerCable ctr;
        ServerPlayer player = ctx.get().getSender();
        CapabilityConnectableAutoIO link = null;
        TileConnectable tile = null;
        CapabilityConnectable connectable = null;
        if (player.f_36096_ instanceof ContainerCableExportFilter) {
            ctr = (ContainerCableExportFilter)player.f_36096_;
            link = ctr.cap;
            tile = ctr.tile;
        }
        if (player.f_36096_ instanceof ContainerCableImportFilter) {
            ctr = (ContainerCableImportFilter)player.f_36096_;
            link = ((ContainerCableImportFilter)ctr).cap;
            tile = ((ContainerCableImportFilter)ctr).tile;
        }
        if (player.f_36096_ instanceof ContainerCollectionFilter) {
            ctr = (ContainerCollectionFilter)player.f_36096_;
            connectable = ((ContainerCollectionFilter)ctr).cap;
            tile = ((ContainerCollectionFilter)ctr).tile;
        }
        TileMain root = null;
        if (link != null) {
            root = UtilTileEntity.getTileMainForConnectable(link.connectable);
        }
        CableMessageType type = CableMessageType.values()[message.id];
        switch (type) {
            case IMPORT_FILTER: {
                link.getFilter().clear();
                int targetSlot = 0;
                for (ItemStack filterSuggestion : link.getStoredStacks(false)) {
                    if (link.getFilter().exactStackAlreadyInList(filterSuggestion)) continue;
                    try {
                        link.getFilter().setStackInSlot(targetSlot, filterSuggestion.m_41777_());
                        if (++targetSlot < link.getFilter().getSlots()) continue;
                    }
                    catch (Exception ex) {
                        StorageNetworkMod.LOGGER.error("Exception saving filter slot ", (Object)message);
                    }
                }
                PacketRegistry.INSTANCE.sendTo((Object)new RefreshFilterClientMessage(link.getFilter().getStacks()), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                break;
            }
            case SYNC_DATA: {
                link.setPriority(link.getPriority() + message.value);
                link.getFilter().setIsAllowlist(message.isAllowlist);
                if (root == null) break;
                root.clearCache();
                break;
            }
            case SAVE_FITLER: {
                if (link != null) {
                    link.setFilter(message.value, message.stack.m_41777_());
                    break;
                }
                if (connectable == null) break;
                connectable.setFilter(message.value, message.stack.m_41777_());
                break;
            }
            case REDSTONE: {
                if (link != null) {
                    link.toggleNeedsRedstone();
                }
                if (connectable == null) break;
                connectable.toggleNeedsRedstone();
                break;
            }
            case SYNC_OP: {
                link.operationType = message.value;
                break;
            }
            case SYNC_OP_STACK: {
                link.operationStack = message.stack;
                break;
            }
            case SYNC_OP_TEXT: {
                link.operationLimit = message.value;
                break;
            }
        }
        tile.m_6596_();
        player.f_8906_.m_9829_((Packet)tile.getUpdatePacket());
    }

    public static void encode(CableIOMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.id);
        buffer.writeInt(msg.value);
        buffer.writeBoolean(msg.isAllowlist);
        buffer.m_130079_(msg.stack.m_41739_(new CompoundTag()));
    }

    public static CableIOMessage decode(FriendlyByteBuf buffer) {
        CableIOMessage c = new CableIOMessage(buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        c.stack = ItemStack.m_41712_((CompoundTag)buffer.m_130260_());
        return c;
    }

    public static enum CableMessageType {
        SYNC_DATA,
        IMPORT_FILTER,
        SAVE_FITLER,
        REDSTONE,
        SYNC_OP,
        SYNC_OP_TEXT,
        SYNC_OP_STACK;

    }
}

