/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.PlantType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;

public class SlimeTallGrassBlock
extends BushBlock
implements IForgeShearable {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final FoliageType foliageType;

    public SlimeTallGrassBlock(BlockBehaviour.Properties properties, FoliageType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return TinkerWorld.SLIME_PLANT_TYPE;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this, 1)});
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Block block = state.m_60734_();
        return TinkerWorld.slimeDirt.contains((Object)block) || TinkerWorld.vanillaSlimeGrass.contains((Object)block) || TinkerWorld.earthSlimeGrass.contains((Object)block) || TinkerWorld.skySlimeGrass.contains((Object)block) || TinkerWorld.enderSlimeGrass.contains((Object)block) || TinkerWorld.ichorSlimeGrass.contains((Object)block);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.foliageType != FoliageType.ICHOR) {
            super.m_49811_(group, items);
        }
    }

    public FoliageType getFoliageType() {
        return this.foliageType;
    }
}

