/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class EntityMovementChangePacket
implements IThreadsafePacket {
    private final int entityID;
    private final double x;
    private final double y;
    private final double z;
    private final float yRot;
    private final float xRot;

    public EntityMovementChangePacket(Entity entity) {
        this.entityID = entity.m_19879_();
        this.x = entity.m_20184_().f_82479_;
        this.y = entity.m_20184_().f_82480_;
        this.z = entity.m_20184_().f_82481_;
        this.yRot = entity.m_146908_();
        this.xRot = entity.m_146909_();
    }

    public EntityMovementChangePacket(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.yRot = buffer.readFloat();
        this.xRot = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.entityID);
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.writeFloat(this.yRot);
        packetBuffer.writeFloat(this.xRot);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        if (context.getSender() != null) {
            HandleClient.handle(this);
        }
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(EntityMovementChangePacket packet) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
            if (entity != null) {
                entity.m_20334_(packet.x, packet.y, packet.z);
                entity.m_146922_(packet.yRot);
                entity.m_146926_(packet.xRot);
            }
        }
    }
}

