/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.listener.ISafeManagerReloadListener;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.MultilayerArmorModel;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.utils.SimpleCache;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class SlimeskullArmorModel
extends MultilayerArmorModel {
    public static final SlimeskullArmorModel INSTANCE = new SlimeskullArmorModel();
    private static final SimpleCache<String, Integer> MATERIAL_COLOR_CACHE = new SimpleCache<String, Integer>(mat -> Optional.ofNullable(MaterialVariantId.tryParse(mat)).flatMap(MaterialRenderInfoLoader.INSTANCE::getRenderInfo).map(MaterialRenderInfo::getVertexColor).orElse(-1));
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> {
        HEAD_MODELS = null;
        MATERIAL_COLOR_CACHE.clear();
    };
    @Nullable
    private ResourceLocation headTexture;
    private int headColor = -1;
    @Nullable
    private SkullModelBase headModel;
    private static final Map<MaterialId, Function<EntityModelSet, ? extends SkullModelBase>> HEAD_MODEL_FACTORIES = new HashMap<MaterialId, Function<EntityModelSet, ? extends SkullModelBase>>();
    private static final Map<MaterialId, ResourceLocation> HEAD_TEXTURES = new HashMap<MaterialId, ResourceLocation>();
    private static Map<MaterialId, SkullModelBase> HEAD_MODELS;

    private SlimeskullArmorModel() {
    }

    public Model setup(LivingEntity living, ItemStack stack, HumanoidModel<?> base, ArmorModelManager.ArmorModel model) {
        super.setup(living, stack, EquipmentSlot.HEAD, base, model);
        MaterialId materialId = MaterialIdNBT.from(stack).getMaterial(0).getId();
        if (!materialId.equals(IMaterial.UNKNOWN_ID)) {
            SkullModelBase skull = SlimeskullArmorModel.getHeadModel(materialId);
            ResourceLocation texture = HEAD_TEXTURES.get(materialId);
            if (skull != null && texture != null) {
                String embellishmentMaterial;
                this.headModel = skull;
                this.headTexture = texture;
                if (ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0) {
                    embellishmentMaterial = MaterialIds.gold.toString();
                } else {
                    embellishmentMaterial = ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
                    if (embellishmentMaterial.isEmpty()) {
                        embellishmentMaterial = MaterialIds.enderslime.toString();
                    }
                }
                this.headColor = MATERIAL_COLOR_CACHE.apply(embellishmentMaterial);
                return this;
            }
        }
        this.headTexture = null;
        this.headModel = null;
        this.headColor = -1;
        return this;
    }

    @Override
    public void m_7695_(PoseStack matrixStackIn, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null && buffer != null) {
            if (this.model != ArmorModelManager.ArmorModel.EMPTY) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, this.base.f_102610_ ? -0.015 : -0.02, 0.0);
                matrixStackIn.m_85841_(1.01f, 1.1f, 1.01f);
                super.m_7695_(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStackIn.m_85849_();
            }
            if (this.headModel != null && this.headTexture != null) {
                VertexConsumer headBuilder = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110464_((ResourceLocation)this.headTexture), (boolean)false, (boolean)this.hasGlint);
                matrixStackIn.m_85836_();
                if (this.base.f_102817_) {
                    matrixStackIn.m_85837_(0.0, (double)(this.base.f_102808_.f_104201_ / 16.0f), 0.0);
                }
                if (this.base.f_102610_) {
                    matrixStackIn.m_85841_(0.85f, 0.85f, 0.85f);
                    matrixStackIn.m_85837_(0.0, 1.0, 0.0);
                } else {
                    matrixStackIn.m_85841_(1.115f, 1.115f, 1.115f);
                }
                this.headModel.m_6251_(0.0f, this.base.f_102808_.f_104204_ * 180.0f / (float)Math.PI, this.base.f_102808_.f_104203_ * 180.0f / (float)Math.PI);
                this.renderColored((Model)this.headModel, matrixStackIn, headBuilder, packedLightIn, packedOverlayIn, this.headColor, red, green, blue, alpha);
                matrixStackIn.m_85849_();
            }
        }
    }

    public static void registerHeadModel(MaterialId materialId, ModelLayerLocation headModel, ResourceLocation texture) {
        SlimeskullArmorModel.registerHeadModel(materialId, (EntityModelSet modelSet) -> new SkullModel(modelSet.m_171103_(headModel)), texture);
    }

    public static void registerHeadModel(MaterialId materialId, Function<EntityModelSet, ? extends SkullModelBase> headFunction, ResourceLocation texture) {
        if (HEAD_MODEL_FACTORIES.containsKey(materialId)) {
            throw new IllegalArgumentException("Duplicate head model " + materialId);
        }
        HEAD_MODEL_FACTORIES.put(materialId, headFunction);
        HEAD_TEXTURES.put(materialId, texture);
    }

    @Nullable
    private static SkullModelBase getHeadModel(MaterialId materialId) {
        if (HEAD_MODELS == null) {
            EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry<MaterialId, Function<EntityModelSet, ? extends SkullModelBase>> entry : HEAD_MODEL_FACTORIES.entrySet()) {
                models.put((Object)entry.getKey(), (Object)entry.getValue().apply(modelSet));
            }
            HEAD_MODELS = models.build();
        }
        return HEAD_MODELS.get(materialId);
    }
}

