/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.listener.ISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.armor.AbstractArmorModel;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.client.model.TinkerItemProperties;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.client.modifiers.DyedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.MaterialModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.client.modifiers.TankModifierModel;
import slimeknights.tconstruct.library.client.particle.AttackParticle;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.HarvestTiers;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.client.CrystalshotRenderer;
import slimeknights.tconstruct.tools.client.FluidEffectProjectileRenderer;
import slimeknights.tconstruct.tools.client.OverslimeModifierModel;
import slimeknights.tconstruct.tools.client.SlimeskullArmorModel;
import slimeknights.tconstruct.tools.client.ToolContainerScreen;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modifiers.ability.armor.DoubleJumpModifier;
import slimeknights.tconstruct.tools.network.TinkerControlPacket;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolClientEvents
extends ClientEventBase {
    private static final KeyMapping HELMET_INTERACT = new KeyMapping(TConstruct.makeTranslationKey("key", "helmet_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.z"), "key.categories.tconstruct");
    private static final KeyMapping LEGGINGS_INTERACT = new KeyMapping(TConstruct.makeTranslationKey("key", "leggings_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.i"), "key.categories.tconstruct");
    private static final ISafeManagerReloadListener MODIFIER_RELOAD_LISTENER = manager -> ModifierManager.INSTANCE.getAllValues().forEach(modifier -> modifier.clearCache(PackType.CLIENT_RESOURCES));
    private static boolean wasJumping = false;
    private static boolean wasHelmetInteracting = false;
    private static boolean wasLeggingsInteracting = false;

    @SubscribeEvent
    static void addResourceListener(RegisterClientReloadListenersEvent manager) {
        ModifierModelManager.init(manager);
        MaterialTooltipCache.init(manager);
        DynamicTextureLoader.init(manager);
        manager.registerReloadListener((PreparableReloadListener)MODIFIER_RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)SlimeskullArmorModel.RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)HarvestTiers.RELOAD_LISTENER);
        ArmorModelManager.init(manager);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("material", MaterialModel.LOADER);
        event.register("tool", ToolModel.LOADER);
    }

    @SubscribeEvent
    static void registerModifierModels(ModifierModelManager.ModifierModelRegistrationEvent event) {
        event.registerModel(TConstruct.getResource("normal"), NormalModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("overslime"), OverslimeModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("fluid"), FluidModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("tank"), TankModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("material"), MaterialModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("dyed"), DyedModifierModel.UNBAKED_INSTANCE);
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TinkerTools.indestructibleItem.get(), ItemEntityRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.crystalshotEntity.get(), CrystalshotRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerModifiers.fluidSpitEntity.get(), FluidEffectProjectileRenderer::new);
    }

    @SubscribeEvent
    static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(HELMET_INTERACT);
        event.register(LEGGINGS_INTERACT);
    }

    @SubscribeEvent
    static void clientSetupEvent(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::handleKeyBindings);
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::handleInput);
        AbstractArmorModel.init();
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)TinkerTools.toolContainer.get()), ToolContainerScreen::new);
            TinkerItemProperties.registerToolProperties(TinkerTools.pickaxe.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.sledgeHammer.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.veinHammer.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.mattock.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.pickadze.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.excavator.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.handAxe.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.broadAxe.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.kama.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.scythe.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.dagger.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.sword.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.cleaver.m_5456_());
            TinkerItemProperties.registerCrossbowProperties(TinkerTools.crossbow.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.longbow.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.flintAndBrick.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.skyStaff.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.earthStaff.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.ichorStaff.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.enderStaff.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.meltingPan.m_5456_());
            TinkerItemProperties.registerCrossbowProperties(TinkerTools.warPick.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.battlesign.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.travelersShield.m_5456_());
            TinkerItemProperties.registerToolProperties(TinkerTools.plateShield.m_5456_());
            Consumer<Item> brokenConsumer = TinkerItemProperties::registerBrokenProperty;
            TinkerTools.travelersGear.forEach(brokenConsumer);
            TinkerTools.plateArmor.forEach(brokenConsumer);
            TinkerTools.slimesuit.forEach(brokenConsumer);
        });
    }

    @SubscribeEvent
    static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine.SpriteParticleRegistration factory = AttackParticle.Factory::new;
        event.register((ParticleType)TinkerTools.hammerAttackParticle.get(), factory);
        event.register((ParticleType)TinkerTools.axeAttackParticle.get(), factory);
        event.register((ParticleType)TinkerTools.bonkAttackParticle.get(), factory);
    }

    @SubscribeEvent
    static void itemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ToolModel.registerItemColors(colors, TinkerTools.pickaxe);
        ToolModel.registerItemColors(colors, TinkerTools.sledgeHammer);
        ToolModel.registerItemColors(colors, TinkerTools.veinHammer);
        ToolModel.registerItemColors(colors, TinkerTools.mattock);
        ToolModel.registerItemColors(colors, TinkerTools.pickadze);
        ToolModel.registerItemColors(colors, TinkerTools.excavator);
        ToolModel.registerItemColors(colors, TinkerTools.handAxe);
        ToolModel.registerItemColors(colors, TinkerTools.broadAxe);
        ToolModel.registerItemColors(colors, TinkerTools.kama);
        ToolModel.registerItemColors(colors, TinkerTools.scythe);
        ToolModel.registerItemColors(colors, TinkerTools.dagger);
        ToolModel.registerItemColors(colors, TinkerTools.sword);
        ToolModel.registerItemColors(colors, TinkerTools.cleaver);
        ToolModel.registerItemColors(colors, TinkerTools.crossbow);
        ToolModel.registerItemColors(colors, TinkerTools.longbow);
        ToolModel.registerItemColors(colors, TinkerTools.meltingPan);
        ToolModel.registerItemColors(colors, TinkerTools.warPick);
        ToolModel.registerItemColors(colors, TinkerTools.battlesign);
        ToolModel.registerItemColors(colors, TinkerTools.travelersShield);
        ToolModel.registerItemColors(colors, TinkerTools.plateShield);
        Consumer<Item> brokenConsumer = item -> event.register(ToolModel.COLOR_HANDLER, new ItemLike[]{item});
        TinkerTools.travelersGear.forEach(brokenConsumer);
        TinkerTools.plateArmor.forEach(brokenConsumer);
        TinkerTools.slimesuit.forEach(brokenConsumer);
        event.register((stack, index) -> {
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (modifier != null) {
                return ResourceColorManager.getColor((String)Util.makeTranslationKey("modifier", modifier));
            }
            return -1;
        }, new ItemLike[]{TinkerModifiers.modifierCrystal.m_5456_()});
    }

    private static void handleKeyBindings(TickEvent.PlayerTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91074_ == event.player && event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT && !minecraft.f_91074_.m_5833_()) {
            TooltipKey key;
            TooltipKey key2;
            boolean isJumping = minecraft.f_91066_.f_92089_.m_90857_();
            if (!wasJumping && isJumping && DoubleJumpModifier.extraJump(event.player)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.DOUBLE_JUMP);
            }
            wasJumping = isJumping;
            boolean isHelmetInteracting = HELMET_INTERACT.m_90857_();
            if (!wasHelmetInteracting && isHelmetInteracting && InteractionHandler.startArmorInteract(event.player, EquipmentSlot.HEAD, key2 = SafeClientAccess.getTooltipKey())) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.getStartHelmetInteract(key2));
            }
            if (wasHelmetInteracting && !isHelmetInteracting && InteractionHandler.stopArmorInteract(event.player, EquipmentSlot.HEAD)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_HELMET_INTERACT);
            }
            boolean isLeggingsInteract = LEGGINGS_INTERACT.m_90857_();
            if (!wasLeggingsInteracting && isLeggingsInteract && InteractionHandler.startArmorInteract(event.player, EquipmentSlot.LEGS, key = SafeClientAccess.getTooltipKey())) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.getStartLeggingsInteract(key));
            }
            if (wasLeggingsInteracting && !isLeggingsInteract && InteractionHandler.stopArmorInteract(event.player, EquipmentSlot.LEGS)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_LEGGINGS_INTERACT);
            }
            wasHelmetInteracting = isHelmetInteracting;
            wasLeggingsInteracting = isLeggingsInteract;
        }
    }

    private static void handleInput(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        if (player.m_6117_() && !player.m_20159_()) {
            ItemStack using = player.m_21211_();
            float speed = 0.2f;
            if (using.m_204117_(TinkerTags.Items.HELD)) {
                ToolStack tool = ToolStack.from(using);
                speed = tool.getStats().get(ToolStats.USE_ITEM_SPEED).floatValue();
            }
            speed = Mth.m_14036_((float)(speed + ArmorStatModule.getStat((Entity)player, TinkerDataKeys.USE_ITEM_SPEED)), (float)0.0f, (float)1.0f);
            Input input = event.getInput();
            input.f_108566_ *= speed * 5.0f;
            input.f_108567_ *= speed * 5.0f;
        }
    }
}

