/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class GenericTagUtil {
    private GenericTagUtil() {
    }

    public static <T> Map<TagKey<T>, List<T>> mapLoaderResults(ResourceKey<? extends Registry<T>> registry, Map<ResourceLocation, Collection<T>> map) {
        return map.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)((ResourceLocation)entry.getKey())), entry -> List.copyOf((Collection)entry.getValue())));
    }

    public static <T, I extends ResourceLocation> Map<I, Set<TagKey<T>>> reverseTags(Function<T, I> keyMapper, Map<TagKey<T>, ? extends Collection<T>> tags) {
        HashMap<ResourceLocation, ImmutableSet.Builder> reverseTags = new HashMap<ResourceLocation, ImmutableSet.Builder>();
        Function<ResourceLocation, ImmutableSet.Builder> makeSet = id -> ImmutableSet.builder();
        for (Map.Entry<TagKey<T>, Collection<T>> entry2 : tags.entrySet()) {
            TagKey<T> key = entry2.getKey();
            for (T value : entry2.getValue()) {
                reverseTags.computeIfAbsent((ResourceLocation)keyMapper.apply(value), makeSet).add(key);
            }
        }
        return reverseTags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
    }

    public static <T> Map<TagKey<T>, List<T>> decodeTags(FriendlyByteBuf buf, ResourceKey<? extends Registry<T>> registry, Function<ResourceLocation, T> valueGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int mapSize = buf.m_130242_();
        for (int i = 0; i < mapSize; ++i) {
            ResourceLocation tagId = buf.m_130281_();
            int tagSize = buf.m_130242_();
            ImmutableList.Builder tagBuilder = ImmutableList.builder();
            for (int j = 0; j < tagSize; ++j) {
                tagBuilder.add(valueGetter.apply(buf.m_130281_()));
            }
            builder.put((Object)TagKey.m_203882_(registry, (ResourceLocation)tagId), (Object)tagBuilder.build());
        }
        return builder.build();
    }

    public static <T> void encodeTags(FriendlyByteBuf buf, Function<T, ResourceLocation> keyGetter, Map<TagKey<T>, ? extends Collection<T>> tags) {
        buf.m_130130_(tags.size());
        for (Map.Entry<TagKey<T>, Collection<T>> entry : tags.entrySet()) {
            buf.m_130085_(entry.getKey().f_203868_());
            Collection<T> values = entry.getValue();
            buf.m_130130_(values.size());
            for (T value : values) {
                buf.m_130085_(keyGetter.apply(value));
            }
        }
    }
}

