/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.IModifierRepairRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairTinkerStationRecipe
implements ITinkerStationRecipe,
IModifierRepairRecipe {
    public static final RecordLoadable<ModifierRepairTinkerStationRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)MODIFIER_FIELD, (RecordField)INGREDIENT_FIELD, (RecordField)REPAIR_AMOUNT_FIELD, ModifierRepairTinkerStationRecipe::new);
    private final ResourceLocation id;
    private final ModifierId modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (!tinkerable.m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        ToolStack tool = inv.getTinkerable();
        if (tool.getModifierLevel(this.modifier) == 0) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable();
        int amountPerItem = tool.getModifierLevel(this.modifier) * this.repairAmount;
        if (amountPerItem <= 0) {
            return RecipeResult.pass();
        }
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return RecipeResult.pass();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, amountPerItem = (int)((float)amountPerItem * repairFactor));
        if (available <= 0) {
            return RecipeResult.pass();
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, available);
        return RecipeResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = inv.getTinkerable();
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return;
        }
        int amountPerItem = (int)((float)(tool.getModifierLevel(this.modifier) * this.repairAmount) * repairFactor);
        if (amountPerItem < 0) {
            return;
        }
        int repairRemaining = tool.getDamage() - ToolStack.from(result).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, repairRemaining, amountPerItem, ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierRepair.get();
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ModifierRepairTinkerStationRecipe(ResourceLocation id, ModifierId modifier, Ingredient ingredient, int repairAmount) {
        this.id = id;
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

