/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairCraftingRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairTinkerStationRecipe;

public class ModifierRepairRecipeBuilder
extends AbstractRecipeBuilder<ModifierRepairRecipeBuilder> {
    private final ModifierId modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    public static ModifierRepairRecipeBuilder repair(LazyModifier modifier, Ingredient ingredient, int repairAmount) {
        return ModifierRepairRecipeBuilder.repair(modifier.getId(), ingredient, repairAmount);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.modifier);
    }

    public ModifierRepairRecipeBuilder buildCraftingTable(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ModifierRepairCraftingRecipe(id, this.modifier, this.ingredient, this.repairAmount), ModifierRepairCraftingRecipe.LOADER, advancementId));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ModifierRepairTinkerStationRecipe(id, this.modifier, this.ingredient, this.repairAmount), ModifierRepairTinkerStationRecipe.LOADER, advancementId));
    }

    private ModifierRepairRecipeBuilder(ModifierId modifier, Ingredient ingredient, int repairAmount) {
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public static ModifierRepairRecipeBuilder repair(ModifierId modifier, Ingredient ingredient, int repairAmount) {
        return new ModifierRepairRecipeBuilder(modifier, ingredient, repairAmount);
    }
}

