/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;

public class AlloyRecipeBuilder
extends AbstractRecipeBuilder<AlloyRecipeBuilder> {
    private final FluidStack output;
    private final int temperature;
    private final List<FluidIngredient> inputs = new ArrayList<FluidIngredient>();

    public static AlloyRecipeBuilder alloy(FluidStack fluid) {
        return AlloyRecipeBuilder.alloy(fluid, fluid.getFluid().getFluidType().getTemperature(fluid) - 300);
    }

    public static AlloyRecipeBuilder alloy(Fluid fluid, int amount) {
        return AlloyRecipeBuilder.alloy(new FluidStack(fluid, amount));
    }

    public AlloyRecipeBuilder addInput(FluidIngredient input) {
        this.inputs.add(input);
        return this;
    }

    public AlloyRecipeBuilder addInput(FluidStack input) {
        return this.addInput(FluidIngredient.of((FluidStack)input));
    }

    public AlloyRecipeBuilder addInput(Fluid fluid, int amount) {
        return this.addInput(FluidIngredient.of((FluidStack)new FluidStack(fluid, amount)));
    }

    public AlloyRecipeBuilder addInput(TagKey<Fluid> tag, int amount) {
        return this.addInput((FluidIngredient)FluidIngredient.of(tag, (int)amount));
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Registry.f_122822_.m_7981_((Object)this.output.getFluid()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.size() < 2) {
            throw new IllegalStateException("Invalid alloying recipe " + id + ", must have at least two inputs");
        }
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new AlloyRecipe(id, this.inputs, this.output, this.temperature), AlloyRecipe.LOADER, this.buildOptionalAdvancement(id, "alloys")));
    }

    private AlloyRecipeBuilder(FluidStack output, int temperature) {
        this.output = output;
        this.temperature = temperature;
    }

    public static AlloyRecipeBuilder alloy(FluidStack output, int temperature) {
        return new AlloyRecipeBuilder(output, temperature);
    }
}

