/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.NamedComponentRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;

public record DamageFluidEffect(List<Consumer<DamageSource>> modifiers, float damage) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final NamedComponentRegistry<Consumer<DamageSource>> SOURCE_MODIFIERS = new NamedComponentRegistry("Unregistered damage source modifier");
    public static final RecordLoadable<DamageFluidEffect> LOADER = RecordLoadable.create((RecordField)SOURCE_MODIFIERS.list(0).defaultField("modifier", List.of(), e -> e.modifiers), (RecordField)FloatLoadable.FROM_ZERO.requiredField("damage", e -> Float.valueOf(e.damage)), DamageFluidEffect::new);
    public static final Consumer<DamageSource> FIRE = DamageFluidEffect.modifier("fire", DamageSource::m_19383_);
    public static final Consumer<DamageSource> EXPLOSION = DamageFluidEffect.modifier("explosion", DamageSource::m_19375_);
    public static final Consumer<DamageSource> MAGIC = DamageFluidEffect.modifier("magic", DamageSource::m_19389_);
    public static final Consumer<DamageSource> FALL = DamageFluidEffect.modifier("fall", DamageSource::m_146708_);
    public static final Consumer<DamageSource> NO_AGGRO = DamageFluidEffect.modifier("no_aggro", DamageSource::m_181120_);
    public static final Consumer<DamageSource> BYPASS_ARMOR = DamageFluidEffect.modifier("bypass_armor", DamageSource::m_19380_);
    public static final Consumer<DamageSource> BYPASS_ENCHANTMENTS = DamageFluidEffect.modifier("bypass_enchantments", DamageSource::m_238403_);
    public static final Consumer<DamageSource> BYPASS_MAGIC = DamageFluidEffect.modifier("bypass_magic", DamageSource::m_19382_);

    @SafeVarargs
    public DamageFluidEffect(float damage, Consumer<DamageSource> ... modifiers) {
        this(List.of(modifiers), damage);
    }

    public RecordLoadable<DamageFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        float value = level.value();
        if (action.simulate()) {
            return value;
        }
        DamageSource source = context.createDamageSource();
        for (Consumer<DamageSource> modifier : this.modifiers) {
            modifier.accept(source);
        }
        return ToolAttackUtil.attackEntitySecondary(source, this.damage * value, context.getTarget(), context.getLivingTarget(), true) ? value : 0.0f;
    }

    private static Consumer<DamageSource> modifier(String name, Consumer<DamageSource> consumer) {
        SOURCE_MODIFIERS.register(TConstruct.getResource(name), consumer);
        return consumer;
    }
}

