/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class TagIntersectionPresentCondition<T>
implements ICondition {
    private static final ResourceLocation NAME = TConstruct.getResource("tag_intersection_present");
    public static final Serializer SERIALIZER = new Serializer();
    private final List<TagKey<T>> names;

    public TagIntersectionPresentCondition(List<TagKey<T>> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a condition with no names");
        }
        this.names = names;
    }

    @SafeVarargs
    public static <T> TagIntersectionPresentCondition<T> ofKeys(TagKey<T> ... names) {
        return new TagIntersectionPresentCondition<T>(Arrays.asList(names));
    }

    public static <T> TagIntersectionPresentCondition<T> ofNames(ResourceKey<? extends Registry<T>> registry, ResourceLocation ... names) {
        return new TagIntersectionPresentCondition<T>(Arrays.stream(names).map(name -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)name)).toList());
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        List<Collection> tags = this.names.stream().map(arg_0 -> ((ICondition.IContext)context).getTag(arg_0)).toList();
        if (tags.size() == 1) {
            return !tags.get(0).isEmpty();
        }
        int count = tags.size();
        for (int i = 1; i < count; ++i) {
            if (!tags.get(i).isEmpty()) continue;
            return false;
        }
        block1: for (Holder entry : tags.get(0)) {
            for (int i = 1; i < count; ++i) {
                if (!tags.get(i).contains(entry)) continue block1;
            }
            return true;
        }
        return false;
    }

    private static class Serializer
    implements IConditionSerializer<TagIntersectionPresentCondition<?>> {
        private Serializer() {
        }

        public void write(JsonObject json, TagIntersectionPresentCondition<?> value) {
            JsonArray names = new JsonArray();
            json.addProperty("registry", value.names.get(0).f_203867_().m_135782_().toString());
            for (TagKey name : value.names) {
                names.add(name.f_203868_().toString());
            }
            json.add("tags", (JsonElement)names);
        }

        private static <T> TagIntersectionPresentCondition<T> readGeneric(JsonObject json) {
            ResourceKey registry = ResourceKey.m_135788_((ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"registry"));
            return new TagIntersectionPresentCondition(JsonHelper.parseList((JsonObject)json, (String)"tags", (element, s) -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)JsonHelper.convertToResourceLocation((JsonElement)element, (String)s))));
        }

        public TagIntersectionPresentCondition<?> read(JsonObject json) {
            return Serializer.readGeneric(json);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

