/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ModelHelper;

public class IncrementalFluidCuboid
extends FluidCuboid {
    private final int increments;

    public IncrementalFluidCuboid(Vector3f from, Vector3f to, Map<Direction, FluidCuboid.FluidFace> faces, int increments) {
        super(from, to, faces);
        this.increments = increments;
    }

    public BlockElement getPart(int amount, boolean gas) {
        Vector3f from = this.getFrom();
        Vector3f to = this.getTo();
        float minY = from.m_122260_();
        float maxY = to.m_122260_();
        if (gas) {
            from = from.m_122281_();
            from.setY(maxY + (float)amount * (minY - maxY) / (float)this.increments);
        } else {
            to = to.m_122281_();
            to.setY(minY + (float)amount * (maxY - minY) / (float)this.increments);
        }
        EnumMap<Direction, BlockElementFace> faces = new EnumMap<Direction, BlockElementFace>(Direction.class);
        for (Map.Entry entry : this.getFaces().entrySet()) {
            Direction dir = (Direction)entry.getKey();
            FluidCuboid.FluidFace face = (FluidCuboid.FluidFace)entry.getValue();
            boolean isFlowing = face.isFlowing();
            faces.put(dir, new BlockElementFace(null, 0, isFlowing ? "flowing_fluid" : "fluid", IncrementalFluidCuboid.getFaceUvs(from, to, dir, face.rotation(), isFlowing ? 0.5f : 1.0f)));
        }
        return new BlockElement(from, to, faces, null, false);
    }

    private static BlockFaceUV getFaceUvs(Vector3f from, Vector3f to, Direction side, int rotation, float scale) {
        float temp;
        float u2;
        float v1;
        float u1;
        float v2 = switch (side) {
            case Direction.DOWN -> {
                u1 = from.m_122239_();
                v1 = 16.0f - to.m_122269_();
                u2 = to.m_122239_();
                yield 16.0f - from.m_122269_();
            }
            case Direction.UP -> {
                u1 = from.m_122239_();
                v1 = from.m_122269_();
                u2 = to.m_122239_();
                yield to.m_122269_();
            }
            default -> {
                u1 = 16.0f - to.m_122239_();
                v1 = 16.0f - to.m_122260_();
                u2 = 16.0f - from.m_122239_();
                yield 16.0f - from.m_122260_();
            }
            case Direction.SOUTH -> {
                u1 = from.m_122239_();
                v1 = 16.0f - to.m_122260_();
                u2 = to.m_122239_();
                yield 16.0f - from.m_122260_();
            }
            case Direction.WEST -> {
                u1 = from.m_122269_();
                v1 = 16.0f - to.m_122260_();
                u2 = to.m_122269_();
                yield 16.0f - from.m_122260_();
            }
            case Direction.EAST -> {
                u1 = 16.0f - to.m_122269_();
                v1 = 16.0f - to.m_122260_();
                u2 = 16.0f - from.m_122269_();
                yield 16.0f - from.m_122260_();
            }
        };
        if (rotation >= 180) {
            temp = v1;
            v1 = 16.0f - v2;
            v2 = 16.0f - temp;
        }
        if (rotation == 90 || rotation == 180) {
            temp = u1;
            u1 = 16.0f - u2;
            u2 = 16.0f - temp;
        }
        float[] uv = rotation % 180 == 90 ? new float[]{v1 * scale, u1 * scale, v2 * scale, u2 * scale} : new float[]{u1 * scale, v1 * scale, u2 * scale, v2 * scale};
        return new BlockFaceUV(uv, rotation);
    }

    public static IncrementalFluidCuboid fromJson(JsonObject json) {
        Vector3f from = ModelHelper.arrayToVector((JsonObject)json, (String)"from");
        Vector3f to = ModelHelper.arrayToVector((JsonObject)json, (String)"to");
        Map faces = IncrementalFluidCuboid.getFaces((JsonObject)json);
        int increments = GsonHelper.m_13927_((JsonObject)json, (String)"increments");
        return new IncrementalFluidCuboid(from, to, faces, increments);
    }

    public int getIncrements() {
        return this.increments;
    }
}

