/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ChannelModel
implements IUnbakedGeometry<ChannelModel> {
    public static final IGeometryLoader<ChannelModel> LOADER = ChannelModel::deserialize;
    private final SimpleBlockModel model;
    private final Map<ChannelModelPart, FluidCuboid> fluids;

    public ChannelModel(SimpleBlockModel model, Map<ChannelModelPart, FluidCuboid> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getMaterials(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bake(owner, bakery, spriteGetter, transform, overrides, location);
        return new Baked(baked, this.fluids);
    }

    public static ChannelModel deserialize(JsonObject json, JsonDeserializationContext context) {
        ColoredBlockModel model = ColoredBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        JsonObject fluidJson = GsonHelper.m_13930_((JsonObject)json, (String)"fluids");
        EnumMap<ChannelModelPart, FluidCuboid> fluids = new EnumMap<ChannelModelPart, FluidCuboid>(ChannelModelPart.class);
        fluids.put(ChannelModelPart.DOWN, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)fluidJson, (String)"down")));
        JsonObject centerJson = GsonHelper.m_13930_((JsonObject)fluidJson, (String)"center");
        fluids.put(ChannelModelPart.CENTER_STILL, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)centerJson, (String)"still")));
        fluids.put(ChannelModelPart.CENTER_FLOWING, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)centerJson, (String)"flowing")));
        JsonObject sideJson = GsonHelper.m_13930_((JsonObject)fluidJson, (String)"side");
        fluids.put(ChannelModelPart.SIDE_STILL, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)sideJson, (String)"still")));
        fluids.put(ChannelModelPart.SIDE_IN, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)sideJson, (String)"in")));
        fluids.put(ChannelModelPart.SIDE_OUT, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)sideJson, (String)"out")));
        fluids.put(ChannelModelPart.SIDE_EDGE, FluidCuboid.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)sideJson, (String)"edge")));
        return new ChannelModel((SimpleBlockModel)model, fluids);
    }

    public static class Baked
    extends BakedModelWrapper<BakedModel> {
        private final Map<ChannelModelPart, FluidCuboid> fluids;

        private Baked(BakedModel originalModel, Map<ChannelModelPart, FluidCuboid> fluids) {
            super(originalModel);
            this.fluids = fluids;
        }

        public FluidCuboid getDownFluid() {
            return this.fluids.get((Object)ChannelModelPart.DOWN);
        }

        public FluidCuboid getCenterFluid(boolean flowing) {
            return this.fluids.get((Object)(flowing ? ChannelModelPart.CENTER_FLOWING : ChannelModelPart.CENTER_STILL));
        }

        public FluidCuboid getSideFlow(boolean out) {
            return this.fluids.get((Object)(out ? ChannelModelPart.SIDE_OUT : ChannelModelPart.SIDE_IN));
        }

        public FluidCuboid getSideStill() {
            return this.fluids.get((Object)ChannelModelPart.SIDE_STILL);
        }

        public FluidCuboid getSideEdge() {
            return this.fluids.get((Object)ChannelModelPart.SIDE_EDGE);
        }
    }

    private static enum ChannelModelPart {
        CENTER_STILL,
        CENTER_FLOWING,
        SIDE_STILL,
        SIDE_IN,
        SIDE_OUT,
        SIDE_EDGE,
        DOWN;

    }
}

