/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class TierRangeMaterialSectionTransformer
extends BookTransformer {
    private static final ResourceLocation KEY = TConstruct.getResource("material_tier");
    private static final IntRange TIER = new IntRange(0, Short.MAX_VALUE);
    private static final Map<ResourceLocation, MaterialType> MATERIAL_TYPES = new HashMap<ResourceLocation, MaterialType>();
    public static final TierRangeMaterialSectionTransformer INSTANCE = new TierRangeMaterialSectionTransformer();

    public static void registerMaterialType(ResourceLocation id, BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> constructor, MaterialStatsId ... stats) {
        if (MATERIAL_TYPES.putIfAbsent(id, new MaterialType(constructor, (Set<MaterialStatsId>)ImmutableSet.copyOf((Object[])stats))) != null) {
            throw new IllegalArgumentException("Duplicate material stat group " + id);
        }
    }

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            JsonElement element = (JsonElement)section.extraData.get(KEY);
            if (element == null) continue;
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)KEY.toString());
                IntRange tier = TIER.getOrDefault(json, "tier");
                TagKey tag = (TagKey)TinkerLoadables.MATERIAL_TAGS.getOrDefault(json, "tag", null);
                ResourceLocation type = JsonHelper.getResourceLocation((JsonObject)json, (String)"type");
                MaterialType typeData = MATERIAL_TYPES.get(type);
                if (typeData == null) {
                    throw new JsonSyntaxException("Invalid material section type " + type);
                }
                Set<MaterialStatsId> visibleStats = typeData.visibleStats();
                Function<MaterialVariantId, AbstractMaterialContent> pageBuilder = typeData.getMapping(GsonHelper.m_13855_((JsonObject)json, (String)"detailed", (boolean)false));
                AbstractMaterialSectionTransformer.createPages(book, section, new ValidMaterial(visibleStats, tier, (TagKey<IMaterial>)tag), pageBuilder);
            }
            catch (JsonSyntaxException e) {
                TConstruct.LOG.error("Failed to parse material tier section data", (Throwable)e);
            }
        }
    }

    private record MaterialType(BiFunction<MaterialVariantId, Boolean, AbstractMaterialContent> pageConstructor, Set<MaterialStatsId> visibleStats) {
        public Function<MaterialVariantId, AbstractMaterialContent> getMapping(boolean detailed) {
            return id -> this.pageConstructor.apply((MaterialVariantId)id, detailed);
        }
    }

    public record ValidMaterial(Set<MaterialStatsId> visibleStats, IntRange tier, @Nullable TagKey<IMaterial> tag) implements Predicate<IMaterial>
    {
        @Override
        public boolean test(IMaterial material) {
            if (!this.tier.test(material.getTier())) {
                return false;
            }
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            MaterialId id = material.getIdentifier();
            if (this.tag != null && !registry.isInTag(id, this.tag)) {
                return false;
            }
            for (IMaterialStats stats : registry.getAllStats(id)) {
                if (!this.visibleStats.contains((Object)stats.getIdentifier())) continue;
                return true;
            }
            return false;
        }
    }
}

