/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class GregTechCEu {
    public static final String MOD_ID = "gtceu";

    public static Emitter.Properties<?> machine() {
        return Emitter.Properties.tile("#hardcoded").customFactory(Machine::new);
    }

    public static Emitter.Properties<?> combustor(int smokeAmount) {
        return GregTechCEu.machine().smoke(smokeAmount, 1.0f);
    }

    public static Emitter.Properties<?> boiler(int smokeAmount) {
        return GregTechCEu.combustor(smokeAmount);
    }

    public static Emitter.Properties<?> largeBoiler(int smokeAmount, String machineCasing, String fireboxCasing) {
        return (Emitter.Properties)GregTechCEu.boiler(smokeAmount).relatedBlocks(new String[]{GregTechCEu.machineCasingBlocks(machineCasing), GregTechCEu.fireboxCasingBlocks(fireboxCasing)});
    }

    public static Emitter.Properties<?> brickOven(int smokeAmount, String bricks) {
        return (Emitter.Properties)GregTechCEu.combustor(smokeAmount).relatedBlocks(new String[]{GregTechCEu.allBlocks(bricks)});
    }

    public static Emitter.Properties<?> cokeOven(int smokeAmount) {
        return (Emitter.Properties)GregTechCEu.combustor(smokeAmount).relatedBlocks(new String[]{GregTechCEu.allBlocks("coke_oven_bricks"), GregTechCEu.allBlocks("coke_oven_hatch")});
    }

    private static String machineCasingBlocks(String type) {
        return GregTechCEu.allBlocks(type + "_machine_casing");
    }

    private static String fireboxCasingBlocks(String type) {
        return GregTechCEu.allBlocks(type + "_firebox_casing");
    }

    private static String allBlocks(String name) {
        return UnitId.from((String)MOD_ID, (String)name).withMetaAll().toString();
    }

    public static class Machine
    extends Emitter {
        public Machine(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties)props.activeStateHardcoded());
        }

        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (nbtSource == null) {
                return false;
            }
            try {
                CompoundTag recipeLogic = TagHelper.serialize(nbtSource).m_128469_("recipeLogic");
                return recipeLogic.m_128461_("status").equalsIgnoreCase("WORKING");
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

