/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.annotation.Ignored;
import com.mrcrayfish.guns.annotation.Optional;
import com.mrcrayfish.guns.client.ClientHandler;
import com.mrcrayfish.guns.common.AmmoContext;
import com.mrcrayfish.guns.common.GripType;
import com.mrcrayfish.guns.compat.BackpackHelper;
import com.mrcrayfish.guns.debug.Debug;
import com.mrcrayfish.guns.debug.IDebugWidget;
import com.mrcrayfish.guns.debug.IEditorMenu;
import com.mrcrayfish.guns.debug.client.screen.widget.DebugButton;
import com.mrcrayfish.guns.debug.client.screen.widget.DebugSlider;
import com.mrcrayfish.guns.debug.client.screen.widget.DebugToggle;
import com.mrcrayfish.guns.item.ScopeItem;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import com.mrcrayfish.guns.util.GunJsonUtil;
import com.mrcrayfish.guns.util.SuperBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Gun
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    protected General general = new General();
    protected Projectile projectile = new Projectile();
    protected Sounds sounds = new Sounds();
    protected Display display = new Display();
    protected Modules modules = new Modules();

    public General getGeneral() {
        return this.general;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
            ItemStack scope = Gun.getScopeStack(heldItem);
            Item patt2958$temp = scope.m_41720_();
            if (patt2958$temp instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)patt2958$temp;
                widgets.add(Pair.of((Object)scope.m_41720_().m_7626_(scope), () -> new DebugButton((Component)Component.m_237113_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getScope(scopeItem))))));
            }
            widgets.add(Pair.of((Object)this.modules.getEditorLabel(), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.modules)))));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        tag.m_128365_("Sounds", (Tag)this.sounds.serializeNBT());
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        tag.m_128365_("Modules", (Tag)this.modules.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Projectile", 10)) {
            this.projectile.deserializeNBT(tag.m_128469_("Projectile"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
        if (tag.m_128425_("Modules", 10)) {
            this.modules.deserializeNBT(tag.m_128469_("Modules"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("projectile", (JsonElement)this.projectile.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", this.sounds.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "display", this.display.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modules", this.modules.toJsonObject());
        return object;
    }

    public static Gun create(CompoundTag tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean canAttachType(@Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null;
                }
                case STOCK: {
                    return this.modules.attachments.stock != null;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel != null;
                }
            }
        }
        return false;
    }

    @Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope;
                }
                case BARREL: {
                    return this.modules.attachments.barrel;
                }
                case STOCK: {
                    return this.modules.attachments.stock;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel;
                }
            }
        }
        return null;
    }

    public boolean canAimDownSight() {
        return this.canAttachType(IAttachment.Type.SCOPE) || this.modules.zoom != null;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, IAttachment.Type type) {
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            return attachment.m_128425_(type.getTagKey(), 10);
        }
        return false;
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            ItemStack scopeStack = ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
            Scope scope = null;
            Item item = scopeStack.m_41720_();
            if (item instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)item;
                if (GunMod.isDebugging()) {
                    return Debug.getScope(scopeItem);
                }
                scope = scopeItem.getProperties();
            }
            return scope;
        }
        return null;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_(type.getTagKey(), 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.getTagKey()));
        }
        return ItemStack.f_41583_;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128457_("AdditionalDamage");
    }

    public static AmmoContext findAmmo(Player player, ResourceLocation id) {
        if (player.m_7500_()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            ItemStack ammo = item != null ? new ItemStack((ItemLike)item, Integer.MAX_VALUE) : ItemStack.f_41583_;
            return new AmmoContext(ammo, null);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return new AmmoContext(stack, (Container)player.m_150109_());
        }
        if (GunMod.backpackedLoaded) {
            return BackpackHelper.findAmmo(player, id);
        }
        return AmmoContext.NONE;
    }

    public static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), id);
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") > 0;
    }

    public static float getFovModifier(ItemStack stack, Gun modifiedGun) {
        Modules.Zoom zoom;
        Scope scope;
        float modifier = 0.0f;
        if (Gun.hasAttachmentEquipped(stack, modifiedGun, IAttachment.Type.SCOPE) && (scope = Gun.getScope(stack)) != null) {
            if (scope.getFovModifier() < 1.0f) {
                return Mth.m_14036_((float)scope.getFovModifier(), (float)0.01f, (float)1.0f);
            }
            modifier -= scope.getAdditionalZoom();
        }
        return (zoom = modifiedGun.getModules().getZoom()) != null ? modifier + zoom.getFovModifier() : 0.0f;
    }

    public static class General
    implements INBTSerializable<CompoundTag> {
        @Optional
        private boolean auto = false;
        private int rate;
        @Ignored
        private GripType gripType = GripType.ONE_HANDED;
        private int maxAmmo;
        @Optional
        private int reloadAmount = 1;
        @Optional
        private float recoilAngle;
        @Optional
        private float recoilKick;
        @Optional
        private float recoilDurationOffset;
        @Optional
        private float recoilAdsReduction = 0.2f;
        @Optional
        private int projectileAmount = 1;
        @Optional
        private boolean alwaysSpread;
        @Optional
        private float spread;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Auto", this.auto);
            tag.m_128405_("Rate", this.rate);
            tag.m_128359_("GripType", this.gripType.getId().toString());
            tag.m_128405_("MaxAmmo", this.maxAmmo);
            tag.m_128405_("ReloadSpeed", this.reloadAmount);
            tag.m_128350_("RecoilAngle", this.recoilAngle);
            tag.m_128350_("RecoilKick", this.recoilKick);
            tag.m_128350_("RecoilDurationOffset", this.recoilDurationOffset);
            tag.m_128350_("RecoilAdsReduction", this.recoilAdsReduction);
            tag.m_128405_("ProjectileAmount", this.projectileAmount);
            tag.m_128379_("AlwaysSpread", this.alwaysSpread);
            tag.m_128350_("Spread", this.spread);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Auto", 99)) {
                this.auto = tag.m_128471_("Auto");
            }
            if (tag.m_128425_("Rate", 99)) {
                this.rate = tag.m_128451_("Rate");
            }
            if (tag.m_128425_("GripType", 8)) {
                this.gripType = GripType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("GripType")));
            }
            if (tag.m_128425_("MaxAmmo", 99)) {
                this.maxAmmo = tag.m_128451_("MaxAmmo");
            }
            if (tag.m_128425_("ReloadSpeed", 99)) {
                this.reloadAmount = tag.m_128451_("ReloadSpeed");
            }
            if (tag.m_128425_("RecoilAngle", 99)) {
                this.recoilAngle = tag.m_128457_("RecoilAngle");
            }
            if (tag.m_128425_("RecoilKick", 99)) {
                this.recoilKick = tag.m_128457_("RecoilKick");
            }
            if (tag.m_128425_("RecoilDurationOffset", 99)) {
                this.recoilDurationOffset = tag.m_128457_("RecoilDurationOffset");
            }
            if (tag.m_128425_("RecoilAdsReduction", 99)) {
                this.recoilAdsReduction = tag.m_128457_("RecoilAdsReduction");
            }
            if (tag.m_128425_("ProjectileAmount", 99)) {
                this.projectileAmount = tag.m_128451_("ProjectileAmount");
            }
            if (tag.m_128425_("AlwaysSpread", 99)) {
                this.alwaysSpread = tag.m_128471_("AlwaysSpread");
            }
            if (tag.m_128425_("Spread", 99)) {
                this.spread = tag.m_128457_("Spread");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.rate > 0 ? 1 : 0) != 0, (Object)"Rate must be more than zero");
            Preconditions.checkArgument((this.maxAmmo > 0 ? 1 : 0) != 0, (Object)"Max ammo must be more than zero");
            Preconditions.checkArgument((this.reloadAmount >= 1 ? 1 : 0) != 0, (Object)"Reload angle must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilAngle >= 0.0f ? 1 : 0) != 0, (Object)"Recoil angle must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilKick >= 0.0f ? 1 : 0) != 0, (Object)"Recoil kick must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilDurationOffset >= 0.0f && this.recoilDurationOffset <= 1.0f ? 1 : 0) != 0, (Object)"Recoil duration offset must be between 0.0 and 1.0");
            Preconditions.checkArgument((this.recoilAdsReduction >= 0.0f && this.recoilAdsReduction <= 1.0f ? 1 : 0) != 0, (Object)"Recoil ads reduction must be between 0.0 and 1.0");
            Preconditions.checkArgument((this.projectileAmount >= 1 ? 1 : 0) != 0, (Object)"Projectile amount must be more than or equal to one");
            Preconditions.checkArgument((this.spread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
            JsonObject object = new JsonObject();
            if (this.auto) {
                object.addProperty("auto", Boolean.valueOf(true));
            }
            object.addProperty("rate", (Number)this.rate);
            object.addProperty("gripType", this.gripType.getId().toString());
            object.addProperty("maxAmmo", (Number)this.maxAmmo);
            if (this.reloadAmount != 1) {
                object.addProperty("reloadAmount", (Number)this.reloadAmount);
            }
            if (this.recoilAngle != 0.0f) {
                object.addProperty("recoilAngle", (Number)Float.valueOf(this.recoilAngle));
            }
            if (this.recoilKick != 0.0f) {
                object.addProperty("recoilKick", (Number)Float.valueOf(this.recoilKick));
            }
            if (this.recoilDurationOffset != 0.0f) {
                object.addProperty("recoilDurationOffset", (Number)Float.valueOf(this.recoilDurationOffset));
            }
            if (this.recoilAdsReduction != 0.2f) {
                object.addProperty("recoilAdsReduction", (Number)Float.valueOf(this.recoilAdsReduction));
            }
            if (this.projectileAmount != 1) {
                object.addProperty("projectileAmount", (Number)this.projectileAmount);
            }
            if (this.alwaysSpread) {
                object.addProperty("alwaysSpread", Boolean.valueOf(true));
            }
            if (this.spread != 0.0f) {
                object.addProperty("spread", (Number)Float.valueOf(this.spread));
            }
            return object;
        }

        public General copy() {
            General general = new General();
            general.auto = this.auto;
            general.rate = this.rate;
            general.gripType = this.gripType;
            general.maxAmmo = this.maxAmmo;
            general.reloadAmount = this.reloadAmount;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.recoilDurationOffset = this.recoilDurationOffset;
            general.recoilAdsReduction = this.recoilAdsReduction;
            general.projectileAmount = this.projectileAmount;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            return general;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public int getRate() {
            return this.rate;
        }

        public GripType getGripType() {
            return this.gripType;
        }

        public int getMaxAmmo() {
            return this.maxAmmo;
        }

        public int getReloadAmount() {
            return this.reloadAmount;
        }

        public float getRecoilAngle() {
            return this.recoilAngle;
        }

        public float getRecoilKick() {
            return this.recoilKick;
        }

        public float getRecoilDurationOffset() {
            return this.recoilDurationOffset;
        }

        public float getRecoilAdsReduction() {
            return this.recoilAdsReduction;
        }

        public int getProjectileAmount() {
            return this.projectileAmount;
        }

        public boolean isAlwaysSpread() {
            return this.alwaysSpread;
        }

        public float getSpread() {
            return this.spread;
        }
    }

    public static class Projectile
    implements INBTSerializable<CompoundTag> {
        private ResourceLocation item = new ResourceLocation("cgm", "basic_ammo");
        @Optional
        private boolean visible;
        private float damage;
        private float size;
        private double speed;
        private int life;
        @Optional
        private boolean gravity;
        @Optional
        private boolean damageReduceOverLife;
        @Optional
        private int trailColor = 16765577;
        @Optional
        private double trailLengthMultiplier = 1.0;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Item", this.item.toString());
            tag.m_128379_("Visible", this.visible);
            tag.m_128350_("Damage", this.damage);
            tag.m_128350_("Size", this.size);
            tag.m_128347_("Speed", this.speed);
            tag.m_128405_("Life", this.life);
            tag.m_128379_("Gravity", this.gravity);
            tag.m_128379_("DamageReduceOverLife", this.damageReduceOverLife);
            tag.m_128405_("TrailColor", this.trailColor);
            tag.m_128347_("TrailLengthMultiplier", this.trailLengthMultiplier);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Item", 8)) {
                this.item = new ResourceLocation(tag.m_128461_("Item"));
            }
            if (tag.m_128425_("Visible", 99)) {
                this.visible = tag.m_128471_("Visible");
            }
            if (tag.m_128425_("Damage", 99)) {
                this.damage = tag.m_128457_("Damage");
            }
            if (tag.m_128425_("Size", 99)) {
                this.size = tag.m_128457_("Size");
            }
            if (tag.m_128425_("Speed", 99)) {
                this.speed = tag.m_128459_("Speed");
            }
            if (tag.m_128425_("Life", 99)) {
                this.life = tag.m_128451_("Life");
            }
            if (tag.m_128425_("Gravity", 99)) {
                this.gravity = tag.m_128471_("Gravity");
            }
            if (tag.m_128425_("DamageReduceOverLife", 99)) {
                this.damageReduceOverLife = tag.m_128471_("DamageReduceOverLife");
            }
            if (tag.m_128425_("TrailColor", 99)) {
                this.trailColor = tag.m_128451_("TrailColor");
            }
            if (tag.m_128425_("TrailLengthMultiplier", 99)) {
                this.trailLengthMultiplier = tag.m_128459_("TrailLengthMultiplier");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
            Preconditions.checkArgument((this.size >= 0.0f ? 1 : 0) != 0, (Object)"Projectile size must be more than or equal to zero");
            Preconditions.checkArgument((this.speed >= 0.0 ? 1 : 0) != 0, (Object)"Projectile speed must be more than or equal to zero");
            Preconditions.checkArgument((this.life > 0 ? 1 : 0) != 0, (Object)"Projectile life must be more than zero");
            Preconditions.checkArgument((this.trailLengthMultiplier >= 0.0 ? 1 : 0) != 0, (Object)"Projectile trail length multiplier must be more than or equal to zero");
            JsonObject object = new JsonObject();
            object.addProperty("item", this.item.toString());
            if (this.visible) {
                object.addProperty("visible", Boolean.valueOf(true));
            }
            object.addProperty("damage", (Number)Float.valueOf(this.damage));
            object.addProperty("size", (Number)Float.valueOf(this.size));
            object.addProperty("speed", (Number)this.speed);
            object.addProperty("life", (Number)this.life);
            if (this.gravity) {
                object.addProperty("gravity", Boolean.valueOf(true));
            }
            if (this.damageReduceOverLife) {
                object.addProperty("damageReduceOverLife", Boolean.valueOf(this.damageReduceOverLife));
            }
            if (this.trailColor != 16765577) {
                object.addProperty("trailColor", (Number)this.trailColor);
            }
            if (this.trailLengthMultiplier != 1.0) {
                object.addProperty("trailLengthMultiplier", (Number)this.trailLengthMultiplier);
            }
            return object;
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.visible = this.visible;
            projectile.damage = this.damage;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            return projectile;
        }

        public ResourceLocation getItem() {
            return this.item;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public float getDamage() {
            return this.damage;
        }

        public float getSize() {
            return this.size;
        }

        public double getSpeed() {
            return this.speed;
        }

        public int getLife() {
            return this.life;
        }

        public boolean isGravity() {
            return this.gravity;
        }

        public boolean isDamageReduceOverLife() {
            return this.damageReduceOverLife;
        }

        public int getTrailColor() {
            return this.trailColor;
        }

        public double getTrailLengthMultiplier() {
            return this.trailLengthMultiplier;
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        private ResourceLocation fire;
        @Optional
        @Nullable
        private ResourceLocation reload;
        @Optional
        @Nullable
        private ResourceLocation cock;
        @Optional
        @Nullable
        private ResourceLocation silencedFire;
        @Optional
        @Nullable
        private ResourceLocation enchantedFire;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.fire != null) {
                tag.m_128359_("Fire", this.fire.toString());
            }
            if (this.reload != null) {
                tag.m_128359_("Reload", this.reload.toString());
            }
            if (this.cock != null) {
                tag.m_128359_("Cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                tag.m_128359_("SilencedFire", this.silencedFire.toString());
            }
            if (this.enchantedFire != null) {
                tag.m_128359_("EnchantedFire", this.enchantedFire.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Fire", 8)) {
                this.fire = this.createSound(tag, "Fire");
            }
            if (tag.m_128425_("Reload", 8)) {
                this.reload = this.createSound(tag, "Reload");
            }
            if (tag.m_128425_("Cock", 8)) {
                this.cock = this.createSound(tag, "Cock");
            }
            if (tag.m_128425_("SilencedFire", 8)) {
                this.silencedFire = this.createSound(tag, "SilencedFire");
            }
            if (tag.m_128425_("EnchantedFire", 8)) {
                this.enchantedFire = this.createSound(tag, "EnchantedFire");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.fire != null) {
                object.addProperty("fire", this.fire.toString());
            }
            if (this.reload != null) {
                object.addProperty("reload", this.reload.toString());
            }
            if (this.cock != null) {
                object.addProperty("cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                object.addProperty("silencedFire", this.silencedFire.toString());
            }
            if (this.enchantedFire != null) {
                object.addProperty("enchantedFire", this.enchantedFire.toString());
            }
            return object;
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.silencedFire = this.silencedFire;
            sounds.enchantedFire = this.enchantedFire;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundTag tag, String key) {
            String sound = tag.m_128461_(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getFire() {
            return this.fire;
        }

        @Nullable
        public ResourceLocation getReload() {
            return this.reload;
        }

        @Nullable
        public ResourceLocation getCock() {
            return this.cock;
        }

        @Nullable
        public ResourceLocation getSilencedFire() {
            return this.silencedFire;
        }

        @Nullable
        public ResourceLocation getEnchantedFire() {
            return this.enchantedFire;
        }
    }

    public static class Display
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        protected Flash flash;

        @Nullable
        public Flash getFlash() {
            return this.flash;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.flash != null) {
                tag.m_128365_("Flash", (Tag)this.flash.serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Flash", 10)) {
                CompoundTag flashTag = tag.m_128469_("Flash");
                if (!flashTag.m_128456_()) {
                    Flash flash = new Flash();
                    flash.deserializeNBT(tag.m_128469_("Flash"));
                    this.flash = flash;
                } else {
                    this.flash = null;
                }
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.flash != null) {
                GunJsonUtil.addObjectIfNotEmpty(object, "flash", this.flash.toJsonObject());
            }
            return object;
        }

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            return display;
        }

        public static class Flash
        extends Positioned {
            private double size = 0.5;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128347_("Size", this.size);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("Size", 99)) {
                    this.size = tag.m_128459_("Size");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                Preconditions.checkArgument((this.size >= 0.0 ? 1 : 0) != 0, (Object)"Muzzle flash size must be more than or equal to zero");
                JsonObject object = super.toJsonObject();
                if (this.size != 0.5) {
                    object.addProperty("size", (Number)this.size);
                }
                return object;
            }

            @Override
            public Flash copy() {
                Flash flash = new Flash();
                flash.size = this.size;
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                return flash;
            }

            public double getSize() {
                return this.size;
            }
        }
    }

    public static class Modules
    implements INBTSerializable<CompoundTag>,
    IEditorMenu {
        private transient Zoom cachedZoom;
        @Optional
        @Nullable
        private Zoom zoom;
        private Attachments attachments = new Attachments();

        @Nullable
        public Zoom getZoom() {
            return this.zoom;
        }

        public Attachments getAttachments() {
            return this.attachments;
        }

        @Override
        public Component getEditorLabel() {
            return Component.m_237113_((String)"Modules");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                widgets.add(Pair.of((Object)Component.m_237113_((String)"Enabled Iron Sights"), () -> new DebugToggle(this.zoom != null, val -> {
                    if (val.booleanValue()) {
                        if (this.cachedZoom != null) {
                            this.zoom = this.cachedZoom;
                        } else {
                            this.cachedZoom = this.zoom = new Zoom();
                        }
                    } else {
                        this.cachedZoom = this.zoom;
                        this.zoom = null;
                    }
                })));
                widgets.add(Pair.of((Object)Component.m_237113_((String)"Adjust Iron Sights"), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> {
                    if (btn.f_93623_ && this.zoom != null) {
                        Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.zoom));
                    }
                }, () -> this.zoom != null)));
            });
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.zoom != null) {
                tag.m_128365_("Zoom", (Tag)this.zoom.serializeNBT());
            }
            tag.m_128365_("Attachments", (Tag)this.attachments.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Zoom", 10)) {
                Zoom zoom = new Zoom();
                zoom.deserializeNBT(tag.m_128469_("Zoom"));
                this.zoom = zoom;
            }
            if (tag.m_128425_("Attachments", 10)) {
                this.attachments.deserializeNBT(tag.m_128469_("Attachments"));
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.zoom != null) {
                object.add("zoom", (JsonElement)this.zoom.toJsonObject());
            }
            GunJsonUtil.addObjectIfNotEmpty(object, "attachments", this.attachments.toJsonObject());
            return object;
        }

        public Modules copy() {
            Modules modules = new Modules();
            if (this.zoom != null) {
                modules.zoom = this.zoom.copy();
            }
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Attachments
        implements INBTSerializable<CompoundTag> {
            @Optional
            @Nullable
            private ScaledPositioned scope;
            @Optional
            @Nullable
            private ScaledPositioned barrel;
            @Optional
            @Nullable
            private ScaledPositioned stock;
            @Optional
            @Nullable
            private ScaledPositioned underBarrel;

            @Nullable
            public ScaledPositioned getScope() {
                return this.scope;
            }

            @Nullable
            public ScaledPositioned getBarrel() {
                return this.barrel;
            }

            @Nullable
            public ScaledPositioned getStock() {
                return this.stock;
            }

            @Nullable
            public ScaledPositioned getUnderBarrel() {
                return this.underBarrel;
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                if (this.scope != null) {
                    tag.m_128365_("Scope", (Tag)this.scope.serializeNBT());
                }
                if (this.barrel != null) {
                    tag.m_128365_("Barrel", (Tag)this.barrel.serializeNBT());
                }
                if (this.stock != null) {
                    tag.m_128365_("Stock", (Tag)this.stock.serializeNBT());
                }
                if (this.underBarrel != null) {
                    tag.m_128365_("UnderBarrel", (Tag)this.underBarrel.serializeNBT());
                }
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Scope", 10)) {
                    this.scope = this.createScaledPositioned(tag, "Scope");
                }
                if (tag.m_128425_("Barrel", 10)) {
                    this.barrel = this.createScaledPositioned(tag, "Barrel");
                }
                if (tag.m_128425_("Stock", 10)) {
                    this.stock = this.createScaledPositioned(tag, "Stock");
                }
                if (tag.m_128425_("UnderBarrel", 10)) {
                    this.underBarrel = this.createScaledPositioned(tag, "UnderBarrel");
                }
            }

            public JsonObject toJsonObject() {
                JsonObject object = new JsonObject();
                if (this.scope != null) {
                    object.add("scope", (JsonElement)this.scope.toJsonObject());
                }
                if (this.barrel != null) {
                    object.add("barrel", (JsonElement)this.barrel.toJsonObject());
                }
                if (this.stock != null) {
                    object.add("stock", (JsonElement)this.stock.toJsonObject());
                }
                if (this.underBarrel != null) {
                    object.add("underBarrel", (JsonElement)this.underBarrel.toJsonObject());
                }
                return object;
            }

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                if (this.stock != null) {
                    attachments.stock = this.stock.copy();
                }
                if (this.underBarrel != null) {
                    attachments.underBarrel = this.underBarrel.copy();
                }
                return attachments;
            }

            @Nullable
            private ScaledPositioned createScaledPositioned(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment);
            }
        }

        public static class Zoom
        extends Positioned
        implements IEditorMenu {
            @Optional
            private float fovModifier;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128350_("FovModifier", this.fovModifier);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("FovModifier", 99)) {
                    this.fovModifier = tag.m_128457_("FovModifier");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                JsonObject object = super.toJsonObject();
                object.addProperty("fovModifier", (Number)Float.valueOf(this.fovModifier));
                return object;
            }

            @Override
            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }

            @Override
            public Component getEditorLabel() {
                return Component.m_237113_((String)"Zoom");
            }

            @Override
            public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)Component.m_237113_((String)"FOV Modifier"), () -> new DebugSlider(0.0, 1.0, this.fovModifier, 0.01, 3, val -> {
                    this.fovModifier = val.floatValue();
                }))));
            }

            public float getFovModifier() {
                return this.fovModifier;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends AbstractBuilder<Builder> {
            }

            protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
            extends Positioned.AbstractBuilder<T> {
                protected final Zoom zoom;

                protected AbstractBuilder() {
                    this(new Zoom());
                }

                protected AbstractBuilder(Zoom zoom) {
                    super(zoom);
                    this.zoom = zoom;
                }

                public T setFovModifier(float fovModifier) {
                    this.zoom.fovModifier = fovModifier;
                    return (T)((AbstractBuilder)this.self());
                }

                @Override
                public Zoom build() {
                    return this.zoom.copy();
                }
            }
        }
    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        protected double scale = 1.0;

        public ScaledPositioned() {
        }

        public ScaledPositioned(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128347_("Scale", this.scale);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("Scale", 99)) {
                this.scale = tag.m_128459_("Scale");
            }
        }

        @Override
        public JsonObject toJsonObject() {
            JsonObject object = super.toJsonObject();
            if (this.scale != 1.0) {
                object.addProperty("scale", (Number)this.scale);
            }
            return object;
        }

        public double getScale() {
            return this.scale;
        }

        @Override
        public ScaledPositioned copy() {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            return positioned;
        }
    }

    public static class Builder {
        private final Gun gun = new Gun();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Gun build() {
            return this.gun.copy();
        }

        public Builder setAuto(boolean auto) {
            this.gun.general.auto = auto;
            return this;
        }

        public Builder setFireRate(int rate) {
            this.gun.general.rate = rate;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.gun.general.gripType = gripType;
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.gun.general.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.gun.general.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.gun.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilKick(float recoilKick) {
            this.gun.general.recoilKick = recoilKick;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.gun.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.gun.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.gun.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.gun.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.gun.general.spread = spread;
            return this;
        }

        public Builder setAmmo(Item item) {
            this.gun.projectile.item = ForgeRegistries.ITEMS.getKey((Object)item);
            return this;
        }

        public Builder setProjectileVisible(boolean visible) {
            this.gun.projectile.visible = visible;
            return this;
        }

        public Builder setProjectileSize(float size) {
            this.gun.projectile.size = size;
            return this;
        }

        public Builder setProjectileSpeed(double speed) {
            this.gun.projectile.speed = speed;
            return this;
        }

        public Builder setProjectileLife(int life) {
            this.gun.projectile.life = life;
            return this;
        }

        public Builder setProjectileAffectedByGravity(boolean gravity) {
            this.gun.projectile.gravity = gravity;
            return this;
        }

        public Builder setProjectileTrailColor(int trailColor) {
            this.gun.projectile.trailColor = trailColor;
            return this;
        }

        public Builder setProjectileTrailLengthMultiplier(int trailLengthMultiplier) {
            this.gun.projectile.trailLengthMultiplier = trailLengthMultiplier;
            return this;
        }

        public Builder setDamage(float damage) {
            this.gun.projectile.damage = damage;
            return this;
        }

        public Builder setReduceDamageOverLife(boolean damageReduceOverLife) {
            this.gun.projectile.damageReduceOverLife = damageReduceOverLife;
            return this;
        }

        public Builder setFireSound(SoundEvent sound) {
            this.gun.sounds.fire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setReloadSound(SoundEvent sound) {
            this.gun.sounds.reload = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setCockSound(SoundEvent sound) {
            this.gun.sounds.cock = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setSilencedFireSound(SoundEvent sound) {
            this.gun.sounds.silencedFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setEnchantedFireSound(SoundEvent sound) {
            this.gun.sounds.enchantedFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setMuzzleFlash(double size, double xOffset, double yOffset, double zOffset) {
            Display.Flash flash = new Display.Flash();
            flash.size = size;
            flash.xOffset = xOffset;
            flash.yOffset = yOffset;
            flash.zOffset = zOffset;
            this.gun.display.flash = flash;
            return this;
        }

        public Builder setZoom(float fovModifier, double xOffset, double yOffset, double zOffset) {
            Modules.Zoom zoom = new Modules.Zoom();
            zoom.fovModifier = fovModifier;
            zoom.xOffset = xOffset;
            zoom.yOffset = yOffset;
            zoom.zOffset = zOffset;
            this.gun.modules.zoom = zoom;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setZoom(Modules.Zoom.Builder builder) {
            this.gun.modules.zoom = builder.build();
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setScope(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.scope = positioned;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setBarrel(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.barrel = positioned;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setStock(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.stock = positioned;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setUnderBarrel(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.underBarrel = positioned;
            return this;
        }
    }

    public static class Positioned
    implements INBTSerializable<CompoundTag> {
        @Optional
        protected double xOffset;
        @Optional
        protected double yOffset;
        @Optional
        protected double zOffset;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("XOffset", this.xOffset);
            tag.m_128347_("YOffset", this.yOffset);
            tag.m_128347_("ZOffset", this.zOffset);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("XOffset", 99)) {
                this.xOffset = tag.m_128459_("XOffset");
            }
            if (tag.m_128425_("YOffset", 99)) {
                this.yOffset = tag.m_128459_("YOffset");
            }
            if (tag.m_128425_("ZOffset", 99)) {
                this.zOffset = tag.m_128459_("ZOffset");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.xOffset != 0.0) {
                object.addProperty("xOffset", (Number)this.xOffset);
            }
            if (this.yOffset != 0.0) {
                object.addProperty("yOffset", (Number)this.yOffset);
            }
            if (this.zOffset != 0.0) {
                object.addProperty("zOffset", (Number)this.zOffset);
            }
            return object;
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }

        public double getZOffset() {
            return this.zOffset;
        }

        public Positioned copy() {
            Positioned positioned = new Positioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            return positioned;
        }

        protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
        extends SuperBuilder<Positioned, T> {
            private final Positioned positioned;

            private AbstractBuilder() {
                this(new Positioned());
            }

            protected AbstractBuilder(Positioned positioned) {
                this.positioned = positioned;
            }

            public T setOffset(double xOffset, double yOffset, double zOffset) {
                this.positioned.xOffset = xOffset;
                this.positioned.yOffset = yOffset;
                this.positioned.zOffset = zOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setXOffset(double xOffset) {
                this.positioned.xOffset = xOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setYOffset(double yOffset) {
                this.positioned.yOffset = yOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setZOffset(double zOffset) {
                this.positioned.zOffset = zOffset;
                return (T)((AbstractBuilder)this.self());
            }

            @Override
            public Positioned build() {
                return this.positioned.copy();
            }
        }

        public static class Builder
        extends AbstractBuilder<Builder> {
        }
    }
}

