/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.FrozenBunkerPools;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.FrozenBunkerStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHousePools;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseStructure;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillagePools;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageStructure;
import com.legacy.blue_skies.world.util.structure_processors.RemoveSnowStructureProcessor;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.tags.FilterHolderSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class SkiesStructures {
    public static final StructureRegistrar<ExtendedJigsawStructure> FROZEN_BUNKER = StructureRegistrar.jigsawBuilder((ResourceLocation)BlueSkies.locate("frozen_bunker")).addPiece(() -> FrozenBunkerStructure.Piece::new).pushStructure(s -> new ExtendedJigsawStructure(s, FrozenBunkerPools.ROOT, 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(FROZEN_BUNKER.getRegistryName(), FrozenBunkerStructure.Piece::new)).biomes(new ResourceKey[]{SkiesBiomes.SLUSHLANDS.getKey()}).popStructure().placement(() -> GridStructurePlacement.builder((int)25, (float)0.7f).build(FROZEN_BUNKER.getRegistryName())).build();
    public static final StructureRegistrar<EverbrightBlindingDungeonStructure> EVERBRIGHT_BLINDING_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("everbright_blinding_dungeon"), () -> () -> EverbrightBlindingDungeonStructure.CODEC).addPiece(() -> EverbrightBlindingDungeonPieces.Piece::new).pushStructure(EverbrightBlindingDungeonStructure::new).biomes(new ResourceKey[]{SkiesBiomes.CALMING_SKIES.getKey(), SkiesBiomes.BRISK_MEADOW.getKey(), SkiesBiomes.BRIGHTLANDS.getKey(), SkiesBiomes.SNOW_COVERED_PINES.getKey()}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, List::of).popStructure().placement(() -> GridStructurePlacement.builder((int)45, (int)31, (float)0.75f).exclusionZone(new GridStructurePlacement.TaggedExclusionZone((HolderSet)BuiltinRegistries.f_235988_.m_203561_(SkiesStructureTags.ON_NATURE_MAPS), 10)).build(EVERBRIGHT_BLINDING_DUNGEON.getRegistryName())).build();
    public static final StructureRegistrar<EverdawnBlindingDungeonStructure> EVERDAWN_BLINDING_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("everdawn_blinding_dungeon"), () -> () -> EverdawnBlindingDungeonStructure.CODEC).addPiece(() -> EverdawnBlindingDungeonPieces.Piece::new).pushStructure(EverdawnBlindingDungeonStructure::new).biomes(new ResourceKey[]{SkiesBiomes.SHADED_WOODLANDS.getKey(), SkiesBiomes.CRYSTAL_DUNES.getKey(), SkiesBiomes.SUNSET_MAPLE_FOREST.getKey(), SkiesBiomes.CRESCENT_ORCHARD.getKey(), SkiesBiomes.CRYSTAL_ROUGHS.getKey(), SkiesBiomes.SEARING_GRASSLAND.getKey()}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, List::of).popStructure().placement(() -> GridStructurePlacement.builder((int)45, (int)31, (float)0.75f).exclusionZone(new GridStructurePlacement.TaggedExclusionZone((HolderSet)BuiltinRegistries.f_235988_.m_203561_(SkiesStructureTags.ON_POISON_MAPS), 10)).build(EVERDAWN_BLINDING_DUNGEON.getRegistryName())).build();
    public static final StructureRegistrar<NatureDungeonStructure> NATURE_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("nature_dungeon"), () -> () -> NatureDungeonStructure.CODEC).addPiece("main", () -> NatureDungeonPieces.Piece::new).addPiece("garden", () -> NatureDungeonPieces.GardenPiece::new).addPiece("stone_fill", () -> NatureDungeonPieces.StoneFillPiece::new).addPiece("air_bubble", () -> NatureDungeonPieces.AirBubblePiece::new).pushStructure(NatureDungeonStructure::new).biomes(new ResourceKey[]{SkiesBiomes.SNOW_COVERED_PINES.getKey()}).spawns(MobCategory.MONSTER, () -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STONELET, 2, 1, 1), new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SPEWTER, 2, 1, 1)}))).popStructure().placement(() -> GridStructurePlacement.builder((int)63, (int)33, (float)0.8f).build(NATURE_DUNGEON.getRegistryName())).build();
    public static final StructureRegistrar<PoisonDungeonStructure> POISON_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("poison_dungeon"), () -> () -> PoisonDungeonStructure.CODEC).addPiece(() -> PoisonDungeonPieces.Piece::new).pushStructure(PoisonDungeonStructure::new).biomes(new ResourceKey[]{SkiesBiomes.SUNSET_MAPLE_FOREST.getKey()}).spawns(MobCategory.MONSTER, () -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20554_, 1, 1, 1), new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 3, 1, 1)}))).popStructure().placement(() -> GridStructurePlacement.builder((int)63, (int)33, (float)0.8f).build(POISON_DUNGEON.getRegistryName())).build();
    public static final StructureRegistrar<ExtendedJigsawStructure> GATEKEEPER_HOUSE = StructureRegistrar.jigsawBuilder((ResourceLocation)BlueSkies.locate("gatekeeper_house")).addPiece(() -> GatekeeperHouseStructure.Piece::new).pushStructure("plains", s -> new ExtendedJigsawStructure(s, GatekeeperHousePools.PLAINS, 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("house_1"), GatekeeperHouseStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(() -> FilterHolderSet.builder((Registry)BuiltinRegistries.f_123865_).tags(true, new TagKey[]{BiomeTags.f_207591_, BiomeTags.f_215816_}).build()).dimensions(new ResourceKey[]{Level.f_46428_}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, List::of).popStructure().pushStructure("snowy", s -> new ExtendedJigsawStructure(s, GatekeeperHousePools.SNOWY, 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("house_2"), GatekeeperHouseStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(() -> FilterHolderSet.builder((Registry)BuiltinRegistries.f_123865_).tags(true, new TagKey[]{BiomeTags.f_207593_, BiomeTags.f_207594_}).build()).dimensions(new ResourceKey[]{Level.f_46428_}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, List::of).popStructure().pushStructure("mountain", s -> new ExtendedJigsawStructure(s, GatekeeperHousePools.MOUNTAIN, 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("house_3"), GatekeeperHouseStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(() -> FilterHolderSet.builder((Registry)BuiltinRegistries.f_123865_).tags(true, new TagKey[]{BiomeTags.f_207606_}).build()).dimensions(new ResourceKey[]{Level.f_46428_}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, List::of).popStructure().placement(() -> GridStructurePlacement.builder().spacing(33).offset(17).config(() -> BlueSkiesConfig.COMMON.getGatekeeperHouseConfig()).build(GATEKEEPER_HOUSE.getRegistryName())).build();
    public static final StructureRegistrar<ExtendedJigsawStructure> BLUE_SKIES_VILLAGE = StructureRegistrar.jigsawBuilder((ResourceLocation)BlueSkies.locate("village")).addPiece(() -> SkiesVillageStructure.Piece::new).pushStructure(SkiesVillageBiomes.CALMING_SKIES.toString(), s -> new ExtendedJigsawStructure(s, SkiesVillagePools.CALMING_SKIES, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("village_1"), SkiesVillageStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(new ResourceKey[]{SkiesBiomes.CALMING_SKIES.getKey()}).popStructure().pushStructure(SkiesVillageBiomes.BRIGHTLANDS.toString(), s -> new ExtendedJigsawStructure(s, SkiesVillagePools.BRIGHTLANDS, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("village_2"), SkiesVillageStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(new ResourceKey[]{SkiesBiomes.SNOW_COVERED_PINES.getKey()}).popStructure().pushStructure(SkiesVillageBiomes.SLUSHLANDS.toString(), s -> new ExtendedJigsawStructure(s, SkiesVillagePools.SLUSHLANDS, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("village_3"), SkiesVillageStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(new ResourceKey[]{SkiesBiomes.SLUSHLANDS.getKey()}).popStructure().pushStructure(SkiesVillageBiomes.SHADED_WOODLANDS.toString(), s -> new ExtendedJigsawStructure(s, SkiesVillagePools.SHADED_WOODLANDS, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("village_4"), SkiesVillageStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(new ResourceKey[]{SkiesBiomes.SHADED_WOODLANDS.getKey()}).popStructure().pushStructure(SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString(), s -> new ExtendedJigsawStructure(s, SkiesVillagePools.SUNSET_MAPLE_FOREST, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("village_5"), SkiesVillageStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(new ResourceKey[]{SkiesBiomes.SUNSET_MAPLE_FOREST.getKey()}).popStructure().pushStructure(SkiesVillageBiomes.CRYSTAL_DUNES.toString(), s -> new ExtendedJigsawStructure(s, SkiesVillagePools.CRYSTAL_DUNES, 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(BlueSkies.locate("village_6"), SkiesVillageStructure.Piece::new)).terrainAdjustment(TerrainAdjustment.BEARD_THIN).biomes(new ResourceKey[]{SkiesBiomes.CRYSTAL_DUNES.getKey()}).popStructure().placement(() -> GridStructurePlacement.builder((int)28, (float)0.75f).exclusionZone(new GridStructurePlacement.TaggedExclusionZone((HolderSet)BuiltinRegistries.f_235988_.m_203561_(SkiesStructureTags.DUNGEONS), 7)).build(BLUE_SKIES_VILLAGE)).build();

    public static void init() {
    }

    public static class ProcessorLists {
        public static final Holder<StructureProcessorList> DECAY_TURQUOISE_STONEBRICK = ProcessorLists.register("decay_turquoise_stonebrick", new StructureProcessorList(List.of(new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.1f, SkiesBlocks.mossy_turquoise_stonebrick), new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.2f, SkiesBlocks.cracked_turquoise_stonebrick))));
        public static final Holder<StructureProcessorList> REMOVE_SNOW = ProcessorLists.register("remove_snow", RemoveSnowStructureProcessor.INSTANCE);
        public static final Holder<StructureProcessorList> SWAP_PORTAL = ProcessorLists.register("swap_portal", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stonebrick, SkiesBlocks.turquoise_stonebrick));
        public static final Holder<StructureProcessorList> MODIFY_GRASS = ProcessorLists.register("modify_grass", (StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_50069_), Blocks.f_50069_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_49994_), Blocks.f_50069_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_50016_), Blocks.f_50069_.m_49966_()))));
        public static final Holder<StructureProcessorList> MODIFY_PATH = ProcessorLists.register("modify_path", (StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_152481_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_152481_, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50440_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50493_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()))));
        public static final Holder<StructureProcessorList> SWAP_PORTAL_MODIFY_GRASS = ProcessorLists.register("swap_portal_modify_grass", RegistryHelper.combineProcessors((Holder[])new Holder[]{SWAP_PORTAL, MODIFY_GRASS}));
        public static final Holder<StructureProcessorList> SWAP_PORTAL_REMOVE_SNOW = ProcessorLists.register("swap_portal_remove_snow", RegistryHelper.combineProcessors((Holder[])new Holder[]{SWAP_PORTAL, REMOVE_SNOW}));
        public static final Holder<StructureProcessorList> CALMING_SKIES_STREET = ProcessorLists.register("calming_skies_street", (StructureProcessor)ProcessorLists.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.bluebright_planks, SkiesBlocks.midnight_sand, SkiesBlocks.midnight_sandstone));
        public static final Holder<StructureProcessorList> BRIGHTLANDS_STREET = ProcessorLists.register("brightlands_street", (StructureProcessor)ProcessorLists.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.starlit_planks, SkiesBlocks.midnight_sand, SkiesBlocks.midnight_sandstone));
        public static final Holder<StructureProcessorList> SLUSHLANDS_STREET = ProcessorLists.register("slushlands_street", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.frostbright_planks, 0.2f, SkiesBlocks.stripped_frostbright_wood));
        public static final Holder<StructureProcessorList> SHADED_WOODLANDS_STREET = ProcessorLists.register("shaded_woodlands_street", (StructureProcessor)ProcessorLists.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.lunar_planks, SkiesBlocks.crystal_sand, SkiesBlocks.crystal_sandstone));
        public static final Holder<StructureProcessorList> SUNSET_MAPLE_FOREST_STREET = ProcessorLists.register("sunset_maple_forest_street", (StructureProcessor)ProcessorLists.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.maple_planks, SkiesBlocks.crystal_sand, SkiesBlocks.crystal_sandstone));
        public static final Holder<StructureProcessorList> CRYSTAL_DUNES = ProcessorLists.register("crystal_dunes_street", new StructureProcessorList(List.of()));

        public static void init() {
        }

        private static Holder<StructureProcessorList> register(String key, StructureProcessor processor) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessor)processor);
        }

        private static Holder<StructureProcessorList> register(String key, StructureProcessorList processorList) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessorList)processorList);
        }

        private static RuleProcessor makeVillagePath(Block path, Block dirt, Block grassBlock, Block bridgeMaterial, @Nullable Block sand, @Nullable Block sandstone) {
            return new RuleProcessor(ProcessorLists.standardPath(path, dirt, grassBlock, bridgeMaterial, sand, sandstone));
        }

        private static List<ProcessorRule> standardPath(Block path, Block dirt, Block grassBlock, Block bridgeMaterial, @Nullable Block sand, @Nullable Block sandstone) {
            ArrayList<ProcessorRule> rules = new ArrayList<ProcessorRule>();
            rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(Blocks.f_49990_), bridgeMaterial.m_49966_()));
            if (sand != null && sandstone != null) {
                rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(sand), sandstone.m_49966_()));
            }
            rules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest(path, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, grassBlock.m_49966_()));
            rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(grassBlock), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()));
            rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(dirt), (RuleTest)new BlockMatchTest(Blocks.f_49990_), bridgeMaterial.m_49966_()));
            return rules;
        }
    }
}

