/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.arcs;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.capability.ArcInventory;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.items.SkiesItemGroups;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.items.util.ColoredNameItem;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class ArcItem
extends ColoredNameItem
implements IArcItem {
    private final int arcId;
    private final String ability;

    public ArcItem(int slotId) {
        this(slotId, "missing");
    }

    public ArcItem(int arcId, String ability) {
        this(arcId, ability, new Item.Properties().m_41491_((CreativeModeTab)SkiesItemGroups.MISC).m_41487_(1));
    }

    public ArcItem(int arcId, String ability, Item.Properties props) {
        super(ArcItem.getColorFromType(arcId), props);
        this.ability = ability;
        this.arcId = arcId;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return SkiesPlayer.getIfPresent(player, skiesPlayer -> {
            if (stack.m_41720_() instanceof IArcItem && !skiesPlayer.getArcInventory().hasArc((IArcItem)stack.m_41720_())) {
                for (int slot = 0; slot < skiesPlayer.getArcInventory().m_6643_(); ++slot) {
                    if (!skiesPlayer.getArcInventory().m_8020_(slot).m_41619_()) continue;
                    skiesPlayer.getArcInventory().m_6836_(slot, stack.m_41777_());
                    ((IArcItem)stack.m_41720_()).onEquip(stack, player);
                    stack.m_41764_(0);
                    skiesPlayer.syncDataToClient();
                    player.m_5496_(this.getEquipSound(this.arcId), 1.0f, 1.0f);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }, () -> InteractionResultHolder.m_19100_((Object)stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> lore, TooltipFlag flag) {
        if (stack.m_41720_() == SkiesItems.aquatic_arc || stack.m_41720_() == SkiesItems.life_arc || stack.m_41720_() == SkiesItems.runic_arc) {
            lore.add((Component)StringUtil.UNFINISHED);
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        int level = this.getFunctionalLevel(stack, (Player)player);
        MutableComponent abilityLabel = Component.m_237115_((String)"gui.blue_skies.item.ability").m_130940_(ChatFormatting.GREEN);
        MutableComponent itemAbility = ((ArcItem)stack.m_41720_()).ability.equals("missing") ? Component.m_237115_((String)String.format("gui.blue_skies.item.ability.missing", new Object[0])) : Component.m_237115_((String)String.format("gui.blue_skies.item.ability.%s.%s", ((ArcItem)stack.m_41720_()).ability, level));
        lore.add((Component)Component.m_237110_((String)"%s: %s", (Object[])new Object[]{abilityLabel, itemAbility}));
        if (this.getMaxLevel() > 0) {
            MutableComponent rarityLabel = Component.m_237115_((String)"gui.blue_skies.item.rarity").m_130940_(ChatFormatting.LIGHT_PURPLE);
            MutableComponent itemRarity = Component.m_237115_((String)String.format("gui.blue_skies.item.rarity.%s", level));
            Boolean hasRunic = SkiesPlayer.getIfPresent(player, skyPlayer -> {
                ArcInventory inv = skyPlayer.getArcInventory();
                return inv.m_18949_(Sets.newHashSet((Object[])new Item[]{SkiesItems.runic_arc})) && inv.getStacks().contains((Object)stack);
            }, () -> false);
            if (hasRunic.booleanValue() && this.getLevel(stack) < this.getMaxLevel()) {
                lore.add((Component)Component.m_237110_((String)"%s: %s (%s)", (Object[])new Object[]{rarityLabel, itemRarity, SkiesItems.runic_arc.m_7626_(new ItemStack((ItemLike)SkiesItems.runic_arc)).getString()}));
            } else {
                lore.add((Component)Component.m_237110_((String)"%s: %s", (Object[])new Object[]{rarityLabel, itemRarity}));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        return this.getFunctionalLevel(stack, (Player)mc.f_91074_) == this.getMaxLevel() && this.getMaxLevel() > 0 || super.m_5812_(stack);
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public int getFunctionalLevel(ItemStack stack, Player player) {
        int level = this.getLevel(stack);
        Boolean hasRunic = SkiesPlayer.getIfPresent(player, skyPlayer -> {
            ArcInventory inv = skyPlayer.getArcInventory();
            return inv.m_18949_(Sets.newHashSet((Object[])new Item[]{SkiesItems.runic_arc})) && inv.getStacks().contains((Object)stack);
        }, () -> false);
        if (level < this.getMaxLevel() && hasRunic.booleanValue()) {
            ++level;
        }
        return level;
    }

    public boolean m_41470_() {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.m_41777_();
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (group == CreativeModeTab.f_40754_) {
            for (int level = 0; level < this.getMaxLevel(); ++level) {
                ItemStack stack = new ItemStack((ItemLike)this);
                this.setLevel(stack, level);
                stacks.add((Object)stack);
            }
            if (this.getMaxLevel() == 0) {
                stacks.add((Object)new ItemStack((ItemLike)this));
            }
        } else {
            super.m_6787_(group, stacks);
        }
    }

    private static ChatFormatting getColorFromType(int dungeonTypeIn) {
        switch (dungeonTypeIn) {
            default: {
                return ChatFormatting.WHITE;
            }
            case 0: {
                return ChatFormatting.DARK_AQUA;
            }
            case 1: {
                return ChatFormatting.GRAY;
            }
            case 2: {
                return ChatFormatting.GREEN;
            }
            case 3: {
                return ChatFormatting.LIGHT_PURPLE;
            }
            case 4: {
                return ChatFormatting.BLUE;
            }
            case 5: {
                return ChatFormatting.RED;
            }
            case 6: 
        }
        return ChatFormatting.GOLD;
    }

    private SoundEvent getEquipSound(int id) {
        switch (id) {
            default: {
                return SoundEvents.f_11675_;
            }
            case 0: {
                return SkiesSounds.ITEM_ETHEREAL_ARC_EQUIP;
            }
            case 1: {
                return SkiesSounds.ITEM_DUSK_ARC_EQUIP;
            }
            case 2: {
                return SkiesSounds.ITEM_NATURE_ARC_EQUIP;
            }
            case 3: {
                return SkiesSounds.ITEM_POISON_ARC_EQUIP;
            }
            case 4: {
                return SkiesSounds.ITEM_AQUATIC_ARC_EQUIP;
            }
            case 5: {
                return SkiesSounds.ITEM_LIFE_ARC_EQUIP;
            }
            case 6: 
        }
        return SkiesSounds.ITEM_RUNIC_ARC_EQUIP;
    }

    @Override
    public void serverTick(ItemStack stack, ServerPlayer player) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(ItemStack stack, LocalPlayer player) {
    }

    @Override
    public void onEquip(ItemStack stack, Player player) {
    }

    @Override
    public void onUnequip(ItemStack stack, Player player) {
    }

    @Override
    public void refresh(ItemStack stack, Player player) {
    }

    @Override
    public void onHit(ItemStack stack, Player player, LivingDamageEvent event) {
    }
}

