/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.villager.SkiesVillagerTrades;
import com.legacy.blue_skies.entities.villager.tasks.GatekeeperTasks;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GatekeeperEntity
extends AbstractVillager
implements RangedAttackMob {
    public static final Predicate<LivingEntity> IS_POSSIBLE_DANGER = entity -> entity instanceof Enemy || entity instanceof Player;
    private static final EntityDataAccessor<Byte> SPELL = SynchedEntityData.m_135353_(GatekeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private SkiesIllagerBossEntity.BossSpellColor activeSpell = SkiesIllagerBossEntity.BossSpellColor.NONE;
    protected int spellTicks;
    public BlockPos homePos;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26360_, (Object)MemoryModuleType.f_26361_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26366_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_26370_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26371_, MemoryModuleType.f_26374_, MemoryModuleType.f_26375_, MemoryModuleType.f_26377_, MemoryModuleType.f_26379_, MemoryModuleType.f_26380_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26323_, MemoryModuleType.f_26363_, MemoryModuleType.f_26324_, MemoryModuleType.f_26325_, MemoryModuleType.f_26326_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, MemoryModuleType.f_26330_, MemoryModuleType.f_26327_});
    private static final ImmutableList<SensorType<? extends Sensor<? super GatekeeperEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26813_, (Object)SensorType.f_26814_, (Object)SensorType.f_26815_);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<GatekeeperEntity, Holder<PoiType>>> VALID_POI = ImmutableMap.of((Object)MemoryModuleType.f_26359_, (p_219625_, p_219626_) -> p_219626_.m_203565_(PoiTypes.f_218060_), (Object)MemoryModuleType.f_26362_, (p_219616_, p_219617_) -> p_219617_.m_203565_(PoiTypes.f_218061_));

    public GatekeeperEntity(EntityType<? extends GatekeeperEntity> type, Level world) {
        super(type, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        ((GroundPathNavigation)this.m_21573_()).m_7008_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CastingASpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new RegenGoal());
        this.f_21345_.m_25352_(1, (Goal)new RangedBowAttackGoal<GatekeeperEntity>(this, 0.65, 10, 15.0f){

            @Override
            public boolean m_8036_() {
                return !GatekeeperEntity.this.isCriticalHealth() && !GatekeeperEntity.this.isSpellcasting() && super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                return !GatekeeperEntity.this.isCriticalHealth() && !GatekeeperEntity.this.isSpellcasting() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, SkiesIllagerBossEntity.class, 32.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 6.0f, 0.7, 1.0, entity -> this.m_5448_() != null && entity == this.m_5448_() || entity instanceof Enemy){

            public boolean m_8036_() {
                return GatekeeperEntity.this.isCriticalHealth() && super.m_8036_();
            }

            public boolean m_8045_() {
                return GatekeeperEntity.this.isCriticalHealth() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> (mob instanceof ArmoredFrostSpiritEntity || mob instanceof AbstractIllager || mob instanceof Zombie) && !(mob instanceof ZombifiedPiglin) && !(mob instanceof SkiesIllagerBossEntity) && !(mob instanceof ArtificialGolemEntity)));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return super.m_6431_(poseIn, sizeIn);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isCriticalHealth() {
        return this.m_21223_() <= this.m_21233_() / 3.0f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 80.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        ItemStack bow = new ItemStack((ItemLike)Items.f_42411_);
        bow.m_41663_(Enchantments.f_44988_, 2);
        this.m_8061_(EquipmentSlot.MAINHAND, bow);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_6710_(LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn != null && this.m_20270_((Entity)entitylivingbaseIn) > 20.0f) {
            return;
        }
        if (entitylivingbaseIn == null) {
            super.m_6710_(entitylivingbaseIn);
            return;
        }
        if (this.m_5448_() == null && this.f_20916_ == 0) {
            this.m_5496_(SoundEvents.f_11675_, 1.2f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_5496_(SkiesSounds.ENTITY_GATEKEEPER_NO, 1.0f, this.m_6100_());
        }
        super.m_6710_(entitylivingbaseIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpellTicks", this.spellTicks);
        if (this.homePos != null) {
            compound.m_128365_("GatekeeperHomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.spellTicks = compound.m_128451_("SpellTicks");
        if (this.f_19853_ instanceof ServerLevel) {
            this.resetBrain((ServerLevel)this.f_19853_);
        }
        if (compound.m_128441_("GatekeeperHomePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("GatekeeperHomePos"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
        if (this.f_19853_.f_46443_ && this.isSpellcasting()) {
            SkiesIllagerBossEntity.BossSpellColor spellColor = this.getSpellType();
            Vec3i particleSpeed = spellColor.colorVec;
            double d0 = (double)particleSpeed.m_123341_() / 255.0;
            double d1 = (double)particleSpeed.m_123342_() / 255.0;
            double d2 = (double)particleSpeed.m_123343_() / 255.0;
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.homePos != null && this.homePos != BlockPos.f_121853_ && EntityUtil.getDistanceToPos((Vec3i)this.m_20183_(), (Vec3i)this.homePos) < 60.0f && (EntityUtil.getDistanceToPos((Vec3i)this.m_20183_(), (Vec3i)this.homePos) >= 30.0f || EntityUtil.getDistanceToPos((Vec3i)this.m_20183_(), (Vec3i)this.homePos) >= 10.0f && !this.f_19853_.m_46461_() && this.f_19853_.m_45527_(this.m_20183_()) && !this.f_19853_.m_45527_(this.homePos))) {
            this.m_21573_().m_26519_((double)this.homePos.m_123341_(), (double)this.homePos.m_123342_(), (double)this.homePos.m_123343_(), (double)0.7f);
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("brain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    protected SoundEvent m_7515_() {
        return this.m_5803_() ? null : (this.m_35306_() ? SkiesSounds.ENTITY_GATEKEEPER_TRADE : SkiesSounds.ENTITY_GATEKEEPER_IDLE);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_GATEKEEPER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_GATEKEEPER_DEATH;
    }

    protected SoundEvent m_6068_(boolean yes) {
        return yes ? this.m_7596_() : SkiesSounds.ENTITY_GATEKEEPER_NO;
    }

    public SoundEvent m_7596_() {
        return SkiesSounds.ENTITY_GATEKEEPER_YES;
    }

    protected SoundEvent getSpellSound() {
        return SkiesSounds.ENTITY_GATEKEEPER_CAST_SPELL;
    }

    public GatekeeperEntity getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean flag;
        ItemStack itemstack = player.m_21120_(hand);
        boolean bl = flag = itemstack.m_41720_() == Items.f_42656_;
        if (flag) {
            itemstack.m_41647_(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() != SkiesItems.gatekeeper_spawn_egg && this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (this.m_5912_() && !this.f_19853_.f_46443_) {
                this.m_5496_(SkiesSounds.ENTITY_GATEKEEPER_NO, 1.0f, this.m_6100_());
                return InteractionResult.PASS;
            }
            if (player.m_21120_(hand).m_41720_() == SkiesBlocks.bag_of_spoils.m_5456_() && !this.f_19853_.f_46443_) {
                this.m_6710_((LivingEntity)player);
                return InteractionResult.PASS;
            }
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return super.m_6071_(player, hand);
            }
            if (!this.f_19853_.f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8058_(MerchantOffer offer) {
        if (offer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected void m_7604_() {
        this.m_35277_(new MerchantOffers(), new VillagerTrades.ItemListing[0], 0);
    }

    public MerchantOffers m_6616_() {
        if (this.f_35261_ == null) {
            this.f_35261_ = new MerchantOffers();
        }
        List trades = SkiesPlayer.getIfPresent(this.m_7962_(), skiesPlayer -> this.getTradesForProgression(skiesPlayer.getBrightProgression(), skiesPlayer.getDawnProgression()), () -> this.getTradesForProgression(0, 0));
        MerchantOffers offers = new MerchantOffers();
        for (VillagerTrades.ItemListing trade : trades) {
            offers.add((Object)trade.m_213663_((Entity)this.m_7962_(), this.f_19796_));
        }
        return offers;
    }

    public List<VillagerTrades.ItemListing> getTradesForProgression(int everbrightProgress, int everdawnProgress) {
        ArrayList<VillagerTrades.ItemListing> trades = new ArrayList<VillagerTrades.ItemListing>();
        trades.add(new SkiesVillagerTrades.SingleTrade.Builder().item((ItemLike)Items.f_42616_, Math.min(64, Math.max(1, BlueSkiesConfig.COMMON.getZealLighterCost()))).result((ItemLike)SkiesItems.zeal_lighter, 1).maxUses(5).givenXP(10).build());
        trades.add(new SkiesVillagerTrades.SingleTrade.Builder().item((ItemLike)Items.f_42517_, 1).result((ItemLike)SkiesItems.blue_journal, 1).maxUses(50).givenXP(0).build());
        if (!this.f_19853_.f_46443_ && this.m_7962_() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)this.m_7962_();
            if (EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_everbright_blinding_key_trade")) || EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_everdawn_blinding_key_trade"))) {
                trades.add(new SkiesVillagerTrades.KeyTrade(Items.f_42517_.m_5456_(), 6, Items.f_42616_, 1, SkiesItems.blinding_key));
            }
            if (everbrightProgress >= 1 && EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_nature_key_trade"))) {
                trades.add(new SkiesVillagerTrades.KeyTrade(SkiesBlocks.nature_stone.m_5456_(), 6, SkiesBlocks.starlit_sapling.m_5456_(), 16, SkiesItems.nature_key));
            }
            if (everdawnProgress >= 1 && EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_poison_key_trade"))) {
                trades.add(new SkiesVillagerTrades.KeyTrade(SkiesBlocks.poison_stone.m_5456_(), 6, Items.f_42591_, 16, SkiesItems.poison_key));
            }
        }
        return trades;
    }

    public void m_6667_(DamageSource cause) {
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_);
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26362_);
        super.m_6667_(cause);
    }

    public void releasePoi(MemoryModuleType<GlobalPos> p_35429_) {
        if (this.f_19853_ instanceof ServerLevel) {
            MinecraftServer minecraftserver = ((ServerLevel)this.f_19853_).m_7654_();
            this.f_20939_.m_21952_(p_35429_).ifPresent(p_186306_ -> {
                ServerLevel serverlevel = minecraftserver.m_129880_(p_186306_.m_122640_());
                if (serverlevel != null) {
                    PoiManager poimanager = serverlevel.m_8904_();
                    Optional optional = poimanager.m_27177_(p_186306_.m_122646_());
                    BiPredicate<GatekeeperEntity, Holder<PoiType>> bipredicate = VALID_POI.get(p_35429_);
                    if (optional.isPresent() && bipredicate.test(this, (Holder<PoiType>)((Holder)optional.get()))) {
                        poimanager.m_27154_(p_186306_.m_122646_());
                        DebugPackets.m_133719_((ServerLevel)serverlevel, (BlockPos)p_186306_.m_122646_());
                    }
                }
            });
        }
    }

    public boolean m_7307_(Entity entityIn) {
        return entityIn instanceof Villager || entityIn instanceof IronGolem || entityIn instanceof GatekeeperEntity || this.m_20031_(entityIn.m_5647_());
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public Brain<GatekeeperEntity> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<GatekeeperEntity> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamicIn) {
        Brain brain = this.m_5490_().m_22073_(dynamicIn);
        this.initBrain((Brain<GatekeeperEntity>)brain);
        return brain;
    }

    public void resetBrain(ServerLevel world) {
        Brain<GatekeeperEntity> brain = this.m_6274_();
        brain.m_21933_(world, (LivingEntity)this);
        this.f_20939_ = brain.m_21973_();
        this.initBrain(this.m_6274_());
    }

    private void initBrain(Brain<GatekeeperEntity> villagerBrain) {
        float f = (float)this.m_21051_(Attributes.f_22279_).m_22135_();
        villagerBrain.m_21912_(Schedule.f_38015_);
        villagerBrain.m_21900_(Activity.f_37978_, GatekeeperTasks.core(f));
        villagerBrain.m_21900_(Activity.f_37982_, GatekeeperTasks.rest(f));
        villagerBrain.m_21900_(Activity.f_37979_, GatekeeperTasks.idle(f));
        villagerBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        villagerBrain.m_21944_(Activity.f_37979_);
        villagerBrain.m_21889_(Activity.f_37979_);
        villagerBrain.m_21862_(this.f_19853_.m_46468_(), this.f_19853_.m_46467_());
    }

    public void m_5802_(BlockPos pos) {
        super.m_5802_(pos);
        this.f_20939_.m_21879_(MemoryModuleType.f_26328_, (Object)this.f_19853_.m_46467_());
    }

    public void m_5796_() {
        super.m_5796_();
        this.f_20939_.m_21879_(MemoryModuleType.f_26329_, (Object)this.f_19853_.m_46467_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmPose getArmPose() {
        if (this.isSpellcasting()) {
            return ArmPose.SPELLCASTING;
        }
        return this.m_5912_() ? ArmPose.BOW_AND_ARROW : ArmPose.CROSSED;
    }

    public boolean isSpellcasting() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpellType(SkiesIllagerBossEntity.BossSpellColor spellType) {
        this.activeSpell = spellType;
        this.f_19804_.m_135381_(SPELL, (Object)((byte)Math.min(255, spellType.id)));
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected SkiesIllagerBossEntity.BossSpellColor getSpellType() {
        return !this.f_19853_.f_46443_ ? this.activeSpell : SkiesIllagerBossEntity.BossSpellColor.getFromId(((Byte)this.f_19804_.m_135370_(SPELL)).byteValue());
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - abstractarrowentity.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !GatekeeperEntity.this.m_5803_() && GatekeeperEntity.this.getSpellTicks() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            GatekeeperEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            GatekeeperEntity.this.setSpellType(SkiesIllagerBossEntity.BossSpellColor.NONE);
        }

        public void m_8037_() {
            if (GatekeeperEntity.this.m_5448_() != null) {
                GatekeeperEntity.this.m_21563_().m_24960_((Entity)GatekeeperEntity.this.m_5448_(), (float)GatekeeperEntity.this.m_8085_(), (float)GatekeeperEntity.this.m_8132_());
            }
        }
    }

    public class RegenGoal
    extends GatekeeperUseSpellGoal {
        public boolean m_8036_() {
            boolean should;
            if (GatekeeperEntity.this.f_19797_ < this.spellCooldown) {
                return false;
            }
            GatekeeperEntity keeper = GatekeeperEntity.this;
            Player player = keeper.f_19853_.m_45930_((Entity)keeper, 30.0);
            boolean criticalHealth = keeper.isCriticalHealth();
            boolean bl = should = !keeper.m_5803_() && !keeper.isSpellcasting() && keeper.m_21223_() < keeper.m_21233_() && (keeper.m_5448_() == null || criticalHealth);
            if (!criticalHealth && player != null) {
                return should && !keeper.m_21574_().m_148306_((Entity)player);
            }
            return should && (criticalHealth && (keeper.m_5448_() != null || keeper.f_20916_ > 0) || player == null);
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        @Override
        protected void castSpell() {
            GatekeeperEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 23, 5, false, false));
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SkiesSounds.ENTITY_GATEKEEPER_PREPARE_REGEN;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellType() {
            return SkiesIllagerBossEntity.BossSpellColor.REGENERATION;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        CROSSED,
        ATTACKING,
        BOW_AND_ARROW,
        SPELLCASTING;

    }

    public abstract class GatekeeperUseSpellGoal
    extends Goal {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean shouldExecute() {
            LivingEntity livingentity = GatekeeperEntity.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (GatekeeperEntity.this.isSpellcasting()) {
                    return false;
                }
                return GatekeeperEntity.this.f_19797_ >= this.spellCooldown;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.spellWarmup > 0;
        }

        public void m_8056_() {
            this.spellWarmup = this.getCastWarmupTime();
            GatekeeperEntity.this.spellTicks = this.getCastingTime();
            this.spellCooldown = GatekeeperEntity.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                GatekeeperEntity.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
            GatekeeperEntity.this.setSpellType(this.getSpellType());
        }

        public void m_8037_() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                GatekeeperEntity.this.m_5496_(GatekeeperEntity.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SkiesIllagerBossEntity.BossSpellColor getSpellType();

        public boolean m_183429_() {
            return true;
        }
    }

    class RangedBowAttackGoal<T extends GatekeeperEntity>
    extends Goal {
        private final T entity;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float maxAttackDistance;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ GatekeeperEntity this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RangedBowAttackGoal(T t, double attackCooldownIn, int n, float f) {
            void maxAttackDistanceIn;
            void mob;
            this.this$0 = (GatekeeperEntity)this$0;
            this.entity = mob;
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.attackCooldown = (int)attackCooldownIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setAttackCooldown(int p_189428_1_) {
            this.attackCooldown = p_189428_1_;
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() == null ? false : this.isBowInMainhand();
        }

        protected boolean isBowInMainhand() {
            ItemStack main = this.entity.m_21205_();
            ItemStack off = this.entity.m_21206_();
            return main.m_41720_() instanceof BowItem || off.m_41720_() instanceof BowItem;
        }

        public boolean m_8045_() {
            return (this.m_8036_() || !this.entity.m_21573_().m_26571_()) && this.isBowInMainhand();
        }

        public void m_8056_() {
            super.m_8056_();
            this.entity.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.m_21561_(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.entity.m_5810_();
        }

        public void m_8037_() {
            LivingEntity livingentity = this.entity.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.entity.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_());
                boolean flag = this.entity.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    this.entity.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.entity.m_21573_().m_5624_((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.entity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (this.entity.m_6117_()) {
                    int i;
                    if (!flag && this.seeTime < -60) {
                        this.entity.m_5810_();
                    } else if (flag && (i = this.entity.m_21252_()) >= 20) {
                        this.entity.m_5810_();
                        this.entity.m_6504_(livingentity, BowItem.m_40661_((int)i));
                        this.attackTime = this.attackCooldown;
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                    this.entity.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.entity, item -> item instanceof BowItem));
                }
            }
        }
    }
}

