/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers;

import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.SyncDataRegistryPacket;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class SkiesSyncedDataManager<K, V, T extends SkiesSyncedDataManager<K, V, T>>
extends SkiesDataManager<K, V> {
    public SkiesSyncedDataManager(String name) {
        super(name);
    }

    public void syncToClient(ServerPlayer serverPlayer) {
        PacketHandler.sendToClient(this.getPacket(), serverPlayer);
    }

    @Internal
    public void setData(SkiesSyncedDataManager<?, ?, ?> newInstance) {
        this.data = newInstance.getData();
    }

    public SyncDataRegistryPacket getPacket() {
        return new SyncDataRegistryPacket(this.getId(), this);
    }

    public int getId() {
        for (int id = 0; id < BlueSkiesData.SYNCED_MANAGERS.size(); ++id) {
            if (((Object)BlueSkiesData.SYNCED_MANAGERS.get(id)).getClass() != ((Object)((Object)this)).getClass()) continue;
            return id;
        }
        return 0;
    }

    public abstract T newInstance();

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        this.data.forEach((key, value) -> {
            CompoundTag entry = new CompoundTag();
            Pair<CompoundTag, CompoundTag> entryNbt = this.entryToNbt(key, value);
            entry.m_128365_("key", (Tag)entryNbt.getFirst());
            entry.m_128365_("value", (Tag)entryNbt.getSecond());
            list.add((Object)entry);
        });
        nbt.m_128365_("data", (Tag)list);
        return nbt;
    }

    public abstract Pair<CompoundTag, CompoundTag> entryToNbt(K var1, V var2);

    public T fromNBT(CompoundTag nbt) {
        T manager = this.newInstance();
        ((ListTag)nbt.m_128423_("data")).forEach(entryInbt -> {
            CompoundTag valueNbt;
            CompoundTag entry;
            CompoundTag keyNbt;
            Pair<K, V> dataEntry;
            if (entryInbt instanceof CompoundTag && (dataEntry = this.entryFromNbt(keyNbt = (entry = (CompoundTag)entryInbt).m_128469_("key"), valueNbt = entry.m_128469_("value"))) != null) {
                manager.registerData(manager.getData(), dataEntry.getFirst(), dataEntry.getSecond());
            }
        });
        return manager;
    }

    @Nullable
    public abstract Pair<K, V> entryFromNbt(CompoundTag var1, CompoundTag var2);

    public void putItem(CompoundTag nbt, String key, Item item) {
        nbt.m_128359_(key, ForgeRegistries.ITEMS.getKey((Object)item).toString());
    }

    public Item getItem(CompoundTag nbt, String key) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_(key)));
    }

    public void putBlock(CompoundTag nbt, String key, Block block) {
        nbt.m_128359_(key, ForgeRegistries.BLOCKS.getKey((Object)block).toString());
    }

    public Block getBlock(CompoundTag nbt, String key) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_(key)));
    }
}

