/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.world;

import com.legacy.blue_skies.client.audio.ambient.SkiesWeatherAmbientSounds;
import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DawnWeatherTick {
    public static final DawnWeatherTick INSTANCE = new DawnWeatherTick();
    private int rainSoundTime;
    private SoundInstance desertWind;

    public void tick(int ticks, ClientLevel level, Minecraft mc, Camera camera) {
        this.tickLoops(mc.m_91106_(), level, ticks, camera);
        float f = level.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            Options options = mc.f_91066_;
            Random random = new Random((long)ticks * 312987231L);
            BlockPos blockpos = camera.m_90588_();
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * f * f) / (options.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockpos2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos.m_7918_(k, 0, l)).m_7495_();
                Biome biome = (Biome)level.m_204166_(blockpos2).m_203334_();
                if (blockpos2.m_123342_() <= 0 || blockpos2.m_123342_() > blockpos.m_123342_() + 10 || blockpos2.m_123342_() < blockpos.m_123342_() - 10 || biome.m_47530_() != Biome.Precipitation.RAIN || !biome.m_198906_(blockpos2)) continue;
                blockpos1 = blockpos2;
                if (options.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
                double d0 = random.nextDouble();
                double d1 = random.nextDouble();
                BlockState blockstate = level.m_8055_(blockpos2);
                FluidState fluidstate = level.m_6425_(blockpos2);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)level, blockpos2);
                double d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.m_76155_((BlockGetter)level, blockpos2);
                double d4 = Math.max(d2, d3);
                SimpleParticleType iparticledata = !fluidstate.m_205070_(FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                level.m_7106_((ParticleOptions)iparticledata, (double)blockpos2.m_123341_() + d0, (double)blockpos2.m_123342_() + d4, (double)blockpos2.m_123343_() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && random.nextInt(3) < this.rainSoundTime++) {
                this.rainSoundTime = 0;
                if (blockpos1.m_123342_() > blockpos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() > Mth.m_14143_((float)blockpos.m_123342_())) {
                    level.m_104677_(blockpos1, level.f_46440_ <= 0.0f ? SkiesSounds.AMBIENT_RAIN_DRIZZLE : SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                } else {
                    level.m_104677_(blockpos1, level.f_46440_ <= 0.0f ? SkiesSounds.AMBIENT_RAIN_DRIZZLE : SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    private void tickLoops(SoundManager soundManager, ClientLevel level, int ticks, Camera camera) {
        Entity entity;
        BlockPos blockpos = camera.m_90588_();
        if (level.m_45517_(LightLayer.SKY, blockpos) <= 0) {
            return;
        }
        if (level.m_46471_() && !soundManager.m_120403_(this.desertWind) && level.m_5962_().m_175515_(Registry.f_122885_).m_203561_(SkiesBiomeTags.HAS_SANDSTORMS).m_203333_(level.m_204166_(blockpos)) && (this.desertWind != null && !soundManager.m_120403_(this.desertWind) || this.desertWind == null && !soundManager.m_120403_(this.desertWind)) && (entity = camera.m_90592_()) instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            this.desertWind = new SkiesWeatherAmbientSounds.SandstormSound(player);
            soundManager.m_120367_(this.desertWind);
        }
    }
}

