/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.audio.ambient;

import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;

public class SkiesWeatherAmbientSounds {

    public static class SandstormSound
    extends AbstractTickableSoundInstance {
        private final LocalPlayer player;
        private int ticksInWeather;

        public SandstormSound(LocalPlayer playerIn) {
            super(SkiesSounds.AMBIENT_SANDSTORM_WIND, SoundSource.AMBIENT, playerIn.m_217043_());
            this.player = playerIn;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.1f;
            this.f_119582_ = true;
        }

        public void m_7788_() {
            boolean shouldPitchLower;
            Minecraft mc = Minecraft.m_91087_();
            BlockPos blockpos = mc.m_91288_().m_20183_();
            boolean shouldStopPlaying = mc.f_91073_.m_45517_(LightLayer.SKY, blockpos) <= 0;
            boolean shouldPlay = mc.f_91073_.m_46471_() && mc.f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_203561_(SkiesBiomeTags.HAS_SANDSTORMS).m_203333_(mc.f_91073_.m_204166_(blockpos)) && !shouldStopPlaying;
            boolean bl = shouldPitchLower = mc.f_91073_.m_45517_(LightLayer.SKY, blockpos) <= 5 && blockpos.m_123342_() >= mc.f_91073_.m_5736_() + 1 && mc.f_91065_.m_93090_().m_93713_() || mc.f_91073_.m_45517_(LightLayer.SKY, blockpos) <= 12;
            if (this.player.m_6084_() && this.ticksInWeather >= 0) {
                this.ticksInWeather = shouldPlay ? ++this.ticksInWeather : (this.ticksInWeather -= 2);
                this.ticksInWeather = Math.min(this.ticksInWeather, 40);
                this.f_119573_ = Math.max(0.0f, Math.min((float)this.ticksInWeather / 40.0f, shouldPitchLower ? 0.8f : 1.0f));
                this.f_119574_ = shouldPitchLower ? 0.7f : 1.0f;
            } else {
                this.m_119609_();
            }
        }
    }

    public static class SnowWindSound
    extends AbstractTickableSoundInstance {
        private final LocalPlayer player;
        private int ticksInWeather;
        private float requestedVolume = 0.8f;
        private float requestedPitch = 1.0f;

        public SnowWindSound(LocalPlayer playerIn) {
            super(SkiesSounds.AMBIENT_SNOW_WIND, SoundSource.AMBIENT, playerIn.m_217043_());
            this.player = playerIn;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.1f;
            this.f_119582_ = true;
        }

        public void m_7788_() {
            boolean shouldPitchLower;
            Level world = this.player.f_19853_;
            Minecraft mc = Minecraft.m_91087_();
            BlockPos blockpos = mc.m_91288_().m_20183_();
            boolean shouldStopPlaying = world.m_45517_(LightLayer.SKY, blockpos) <= 0;
            boolean shouldPlay = world.m_46471_() && ((Biome)world.m_204166_(blockpos).m_203334_()).m_47530_() != Biome.Precipitation.NONE && !shouldStopPlaying;
            boolean bl = shouldPitchLower = world.m_45517_(LightLayer.SKY, blockpos) <= 5 && blockpos.m_123342_() >= world.m_5736_() + 1 && mc.f_91065_.m_93090_().m_93713_() || world.m_45517_(LightLayer.SKY, blockpos) <= 12;
            if (this.player.m_6084_() && this.ticksInWeather >= 0) {
                this.ticksInWeather = shouldPlay ? ++this.ticksInWeather : (this.ticksInWeather -= 2);
                this.ticksInWeather = Math.min(this.ticksInWeather, 40);
                this.f_119573_ = Math.max(0.0f, Math.min(this.f_119573_ + (this.requestedVolume > this.f_119573_ ? 0.05f : -0.05f), 0.8f));
                this.f_119574_ = Math.max(0.0f, Math.min(this.f_119574_ + (this.requestedPitch > this.f_119574_ ? 0.01f : -0.01f), 1.0f));
                this.requestedPitch = shouldPitchLower ? 0.7f : 1.0f;
                this.requestedVolume = shouldPlay ? 0.8f : 0.0f;
            } else {
                this.m_119609_();
            }
        }
    }
}

