/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.recipe;

import com.google.gson.JsonObject;
import earth.terrarium.ad_astra.common.item.FluidContainingItem;
import earth.terrarium.ad_astra.common.registry.ModRecipeSerializers;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;

@MethodsReturnNonnullByDefault
public class SpaceSuitShapedRecipe
extends ShapedRecipe {
    public SpaceSuitShapedRecipe(ShapedRecipe internal) {
        super(internal.m_6423_(), internal.m_6076_(), internal.m_44220_(), internal.m_44221_(), internal.m_7527_(), internal.m_8043_());
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack item;
        ItemStack assemble = super.m_5874_(inv).m_41777_();
        CompoundTag assemblingTag = null;
        HashMap assemblingOxygens = new HashMap();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            item = inv.m_8020_(i);
            if (item.m_41619_()) continue;
            if (item.m_41720_() instanceof ArmorItem) {
                assemblingTag = item.m_41783_();
                continue;
            }
            FluidHooks.safeGetItemFluidManager((ItemStack)item).ifPresent(fluidManager -> this.mergeOxygen(assemblingOxygens, fluidManager.getFluidInTank(0)));
        }
        if (assemblingTag != null) {
            assemble.m_41751_(assemblingTag.m_6426_());
        }
        if (assemblingOxygens.size() > 0 && (item = assemble.m_41720_()) instanceof FluidContainingItem) {
            FluidContainingItem fluidContaining = (FluidContainingItem)item;
            ItemStackHolder itemHolder = new ItemStackHolder(assemble);
            Fluid primaryFluid = assemblingOxygens.entrySet().stream().max(this::compareAmount).map(Map.Entry::getKey).orElse(null);
            long totalOxygen = assemblingOxygens.values().stream().mapToLong(FluidHolder::getFluidAmount).sum();
            fluidContaining.insert(itemHolder, FluidHooks.newFluidHolder((Fluid)primaryFluid, (long)totalOxygen, null));
            if (itemHolder.isDirty()) {
                assemble = itemHolder.getStack();
            }
        }
        return assemble.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SPACE_SUIT_CRAFTING_SERIALIZER.get();
    }

    private void mergeOxygen(Map<Fluid, FluidHolder> map, FluidHolder merging) {
        Fluid fluid = merging.getFluid();
        if (fluid.m_205067_(ModTags.OXYGEN)) {
            FluidHolder current = map.computeIfAbsent(fluid, f -> FluidHooks.newFluidHolder((Fluid)f, (long)0L, null));
            current.setAmount(current.getFluidAmount() + merging.getFluidAmount());
        }
    }

    private int compareAmount(Map.Entry<Fluid, FluidHolder> entry1, Map.Entry<Fluid, FluidHolder> entry2) {
        return Long.compare(entry1.getValue().getFluidAmount(), entry2.getValue().getFluidAmount());
    }

    public static class Serializer
    implements RecipeSerializer<SpaceSuitShapedRecipe> {
        public SpaceSuitShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new SpaceSuitShapedRecipe((ShapedRecipe)this.getWrappedSerializer().m_6729_(recipeId, json));
        }

        public SpaceSuitShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new SpaceSuitShapedRecipe((ShapedRecipe)this.getWrappedSerializer().m_8005_(recipeId, buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, SpaceSuitShapedRecipe recipe) {
            this.getWrappedSerializer().m_6178_(buffer, (Recipe)recipe);
        }

        private RecipeSerializer<ShapedRecipe> getWrappedSerializer() {
            return RecipeSerializer.f_44076_;
        }
    }
}

