/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.ServerModConfiguration;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureHouse;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class GuiHouse
extends GuiStructure {
    protected ServerModConfiguration serverConfiguration;
    private ExtendedButton btnHouseStyle;
    private ExtendedButton btnGlassColor;
    private ExtendedButton btnBedColor;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private boolean allowItemsInChestAndFurnace = true;
    private HouseConfiguration specificConfiguration;
    private ArrayList<HouseConfiguration.HouseStyle> availableHouseStyles;

    public GuiHouse() {
        super("Starter House");
        this.configurationEnum = StructureTagMessage.EnumStructureConfiguration.StartHouse;
    }

    public Component m_142562_() {
        return Component.m_237115_((String)GuiLangKeys.translateString("item.prefab.item_start_house"));
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 215;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.allowItemsInChestAndFurnace = !Minecraft.m_91087_().f_91074_.m_7500_() ? !ClientEventHandler.playerConfig.builtStarterHouse : true;
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.specificConfiguration = ClientEventHandler.playerConfig.getClientConfig("Starter House", HouseConfiguration.class);
        this.configuration = this.specificConfiguration;
        this.configuration.pos = this.pos;
        this.availableHouseStyles = new ArrayList();
        HashMap<String, Boolean> houseConfigurationSettings = this.serverConfiguration.structureOptions.get("item.prefab.item_house");
        boolean selectedStyleInListOfAvailable = false;
        for (HouseConfiguration.HouseStyle style : HouseConfiguration.HouseStyle.values()) {
            if (!houseConfigurationSettings.containsKey(style.getTranslationKey()) || !houseConfigurationSettings.get(style.getTranslationKey()).booleanValue()) continue;
            this.availableHouseStyles.add(style);
            if (!this.specificConfiguration.houseStyle.getDisplayName().equals(style.getDisplayName())) continue;
            selectedStyleInListOfAvailable = true;
        }
        if (this.availableHouseStyles.size() == 0) {
            this.showNoOptionsScreen();
            return;
        }
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        if (!selectedStyleInListOfAvailable) {
            this.specificConfiguration.houseStyle = this.availableHouseStyles.get(0);
        }
        this.selectedStructure = StructureHouse.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouse.class);
        int yOffset = 25;
        if (this.availableHouseStyles.size() > 1) {
            this.btnHouseStyle = this.createAndAddButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.houseStyle.getDisplayName(), false, GuiLangKeys.translateString("prefab.gui.house.style.label"));
            yOffset += 35;
        }
        this.btnBedColor = this.createAndAddDyeButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.bedColor, GuiLangKeys.translateString("prefab.gui.structure.bed_color"));
        this.btnGlassColor = this.createAndAddFullDyeButton(grayBoxX + 8, grayBoxY + (yOffset += 35), 90, 20, this.specificConfiguration.glassColor, GuiLangKeys.translateString("prefab.gui.structure.glass"));
        this.btnAddChest = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 35), "prefab.gui.house.addchest", this.specificConfiguration.addChest, this::buttonClicked);
        this.btnAddMineShaft = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 17), "prefab.gui.house.buildmineshaft", this.specificConfiguration.addMineShaft, this::buttonClicked);
        this.btnAddChestContents = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 17), "prefab.gui.house.addchestcontents", this.specificConfiguration.addChestContents, this::buttonClicked);
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 26, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 313, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 165, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 142;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.m_7333_(matrixStack);
        this.drawControlLeftPanel(matrixStack, x + 2, y + 10, 141, 190);
        this.drawControlRightPanel(matrixStack, imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindAndDrawScaledTexture(this.specificConfiguration.houseStyle.getHousePicture(), matrixStack, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        this.btnAddChest.f_93624_ = this.serverConfiguration.addChests;
        this.btnAddChestContents.f_93624_ = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.f_93624_ = this.serverConfiguration.addMineshaft;
    }

    @Override
    protected void postButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int yOffSet = 15;
        if (this.availableHouseStyles.size() > 1) {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.house.style.label"), x + 8, y + yOffSet, this.textColor);
            yOffSet += 35;
        }
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 8, y + yOffSet, this.textColor);
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 8, y + (yOffSet += 35), this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.specificConfiguration.addBed = this.serverConfiguration.addBed;
        this.specificConfiguration.addChest = this.serverConfiguration.addChests && this.btnAddChest.isChecked();
        this.specificConfiguration.addChestContents = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents && this.btnAddChestContents.isChecked();
        this.specificConfiguration.addCraftingTable = this.serverConfiguration.addCraftingTable;
        this.specificConfiguration.addFurnace = this.serverConfiguration.addFurnace;
        this.specificConfiguration.addMineShaft = this.serverConfiguration.addMineshaft && this.btnAddMineShaft.isChecked();
        this.specificConfiguration.addTorches = this.serverConfiguration.addTorches;
        this.configuration.houseFacing = this.getMinecraft().f_91074_.m_6350_().m_122424_();
        this.performCancelOrBuildOrHouseFacing(button);
        if (button == this.btnHouseStyle) {
            for (int i = 0; i < this.availableHouseStyles.size(); ++i) {
                HouseConfiguration.HouseStyle option = this.availableHouseStyles.get(i);
                HouseConfiguration.HouseStyle chosenOption = null;
                if (this.specificConfiguration.houseStyle.getDisplayName().equals(option.getDisplayName())) {
                    chosenOption = i == this.availableHouseStyles.size() - 1 ? this.availableHouseStyles.get(0) : this.availableHouseStyles.get(i + 1);
                }
                if (chosenOption == null) continue;
                this.specificConfiguration.houseStyle = chosenOption;
                this.selectedStructure = StructureHouse.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouse.class);
                GuiUtils.setButtonText(this.btnHouseStyle, this.specificConfiguration.houseStyle.getDisplayName());
                break;
            }
        } else if (button == this.btnGlassColor) {
            this.specificConfiguration.glassColor = FullDyeColor.ById(this.specificConfiguration.glassColor.getId() + 1);
            GuiUtils.setButtonText(this.btnGlassColor, GuiLangKeys.translateFullDye(this.specificConfiguration.glassColor));
        } else if (button == this.btnBedColor) {
            this.specificConfiguration.bedColor = DyeColor.m_41053_((int)(this.specificConfiguration.bedColor.m_41060_() + 1));
            GuiUtils.setButtonText(this.btnBedColor, GuiLangKeys.translateDye(this.specificConfiguration.bedColor));
        } else if (button == this.btnVisualize) {
            this.performPreview();
        }
    }
}

