/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.predefined.StructureHouse;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.network.NetworkDirection;

public class HouseConfiguration
extends StructureConfiguration {
    private static final String addTorchesTag = "addTorches";
    private static final String addBedTag = "addBed";
    private static final String addCraftingTableTag = "addCraftingTable";
    private static final String addFurnaceTag = "addFurnace";
    private static final String addChestTag = "addChest";
    private static final String addChestContentsTag = "addChestContents";
    private static final String addMineShaftTag = "addMineShaft";
    private static final String hitXTag = "hitX";
    private static final String hitYTag = "hitY";
    private static final String hitZTag = "hitZ";
    private static final String houseFacingTag = "houseFacing";
    private static final String houseStyleTag = "houseStyle";
    private static final String glassColorTag = "glassColor";
    private static final String bedColorTag = "bedColor";
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public FullDyeColor glassColor;
    public DyeColor bedColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.BASIC;
        this.glassColor = FullDyeColor.LIGHT_GRAY;
        this.bedColor = DyeColor.RED;
        this.addTorches = true;
        this.addBed = true;
        this.addCraftingTable = true;
        this.addFurnace = true;
        this.addChest = true;
        this.addChestContents = true;
        this.addMineShaft = true;
    }

    @Override
    public CompoundTag WriteToCompoundTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(addTorchesTag, this.addTorches);
        tag.m_128379_(addBedTag, this.addBed);
        tag.m_128379_(addCraftingTableTag, this.addCraftingTable);
        tag.m_128379_(addFurnaceTag, this.addFurnace);
        tag.m_128379_(addChestTag, this.addChest);
        tag.m_128379_(addChestContentsTag, this.addChestContents);
        tag.m_128379_(addMineShaftTag, this.addMineShaft);
        tag.m_128405_(hitXTag, this.pos.m_123341_());
        tag.m_128405_(hitYTag, this.pos.m_123342_());
        tag.m_128405_(hitZTag, this.pos.m_123343_());
        tag.m_128359_(houseFacingTag, this.houseFacing.m_7912_());
        tag.m_128405_(houseStyleTag, this.houseStyle.value);
        tag.m_128405_(glassColorTag, this.glassColor.getId());
        tag.m_128405_(bedColorTag, this.bedColor.m_41060_());
        return tag;
    }

    @Override
    public HouseConfiguration ReadFromCompoundTag(CompoundTag tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.m_128441_(addTorchesTag)) {
                config.addTorches = tag.m_128471_(addTorchesTag);
            }
            if (tag.m_128441_(addBedTag)) {
                config.addBed = tag.m_128471_(addBedTag);
            }
            if (tag.m_128441_(addCraftingTableTag)) {
                config.addCraftingTable = tag.m_128471_(addCraftingTableTag);
            }
            if (tag.m_128441_(addFurnaceTag)) {
                config.addFurnace = tag.m_128471_(addFurnaceTag);
            }
            if (tag.m_128441_(addChestTag)) {
                config.addChest = tag.m_128471_(addChestTag);
            }
            if (tag.m_128441_(addChestContentsTag)) {
                config.addChestContents = tag.m_128471_(addChestContentsTag);
            }
            if (tag.m_128441_(addMineShaftTag)) {
                config.addMineShaft = tag.m_128471_(addMineShaftTag);
            }
            if (tag.m_128441_(hitXTag)) {
                config.pos = new BlockPos(tag.m_128451_(hitXTag), tag.m_128451_(hitYTag), tag.m_128451_(hitZTag));
            }
            if (tag.m_128441_(houseFacingTag)) {
                config.houseFacing = Direction.m_122402_((String)tag.m_128461_(houseFacingTag));
            }
            if (tag.m_128441_(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.m_128451_(houseStyleTag));
            }
            if (tag.m_128441_(glassColorTag)) {
                config.glassColor = FullDyeColor.ById(tag.m_128451_(glassColorTag));
            }
            if (tag.m_128441_(bedColorTag)) {
                config.bedColor = DyeColor.m_41053_((int)tag.m_128451_(bedColorTag));
            }
        }
        return config;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureHouse structure = (StructureHouse)StructureHouse.CreateInstance(this.houseStyle.getStructureLocation(), StructureHouse.class);
        boolean houseBuilt = structure.BuildStructure(this, world, hitBlockPos, player);
        if (houseBuilt) {
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
            playerConfig.builtStarterHouse = true;
            playerConfig.saveToPlayer(player);
            this.RemoveStructureItemFromPlayer(player, (StructureItem)((Object)ModRegistry.StartHouse.get()));
            Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.house.basic.display", new ResourceLocation("prefab", "textures/gui/house_basic.png"), "assets/prefab/structures/house_basic.zip"),
        RANCH(1, "prefab.gui.house.ranch.display", new ResourceLocation("prefab", "textures/gui/house_ranch.png"), "assets/prefab/structures/house_ranch.zip"),
        LOFT(2, "prefab.gui.house.loft.display", new ResourceLocation("prefab", "textures/gui/house_loft.png"), "assets/prefab/structures/house_loft.zip"),
        HOBBIT(3, "prefab.gui.house.hobbit.display", new ResourceLocation("prefab", "textures/gui/house_hobbit.png"), "assets/prefab/structures/house_hobbit.zip"),
        DESERT(4, "prefab.gui.house.desert.display", new ResourceLocation("prefab", "textures/gui/house_desert.png"), "assets/prefab/structures/house_desert.zip"),
        SNOWY(5, "prefab.gui.house.snowy.display", new ResourceLocation("prefab", "textures/gui/house_snowy.png"), "assets/prefab/structures/house_snow.zip"),
        DESERT2(6, "prefab.gui.house.desert.display2", new ResourceLocation("prefab", "textures/gui/house_desert_2.png"), "assets/prefab/structures/house_desert_2.zip"),
        SUBAQUATIC(7, "prefab.gui.house.subaquatic.display", new ResourceLocation("prefab", "textures/gui/house_subaquatic.png"), "assets/prefab/structures/house_sub_aqua.zip"),
        MODERN(8, "prefab.gui.house.modern.display", new ResourceLocation("prefab", "textures/gui/house_modern.png"), "assets/prefab/structures/house_modern.zip"),
        CAMPSITE(9, "prefab.gui.house.camping.display", new ResourceLocation("prefab", "textures/gui/house_campsite.png"), "assets/prefab/structures/house_campsite.zip"),
        IZBA(10, "prefab.gui.house.izba.display", new ResourceLocation("prefab", "textures/gui/house_izba.png"), "assets/prefab/structures/house_izba.zip"),
        TOWER(11, "prefab.gui.house.tower.display", new ResourceLocation("prefab", "textures/gui/house_tower.png"), "assets/prefab/structures/house_tower.zip"),
        CABIN(12, "prefab.gui.house.cabin.display", new ResourceLocation("prefab", "textures/gui/house_cabin.png"), "assets/prefab/structures/house_cabin.zip"),
        TREE(13, "prefab.gui.house.tree.display", new ResourceLocation("prefab", "textures/gui/house_tree.png"), "assets/prefab/structures/house_tree.zip"),
        MUSHROOM(14, "prefab.gui.house.mushroom.display", new ResourceLocation("prefab", "textures/gui/house_mushroom.png"), "assets/prefab/structures/house_mushroom.zip");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            HouseStyle returnValue = BASIC;
            for (HouseStyle current : HouseStyle.values()) {
                if (current.value != value) continue;
                returnValue = current;
                break;
            }
            return returnValue;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getTranslationKey() {
            return this.displayName;
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

