/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.gui.controls.CustomButton;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiTextBox;
import com.wuest.prefab.structures.messages.StructureScannerActionMessage;
import com.wuest.prefab.structures.messages.StructureScannerSyncMessage;
import java.awt.Color;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class GuiStructureScanner
extends GuiBase {
    private final BlockPos blockPos;
    private final Level world;
    private StructureScannerConfig config;
    private ExtendedButton btnStartingPositionMoveLeft;
    private ExtendedButton btnStartingPositionMoveRight;
    private ExtendedButton btnStartingPositionMoveDown;
    private ExtendedButton btnStartingPositionMoveUp;
    private ExtendedButton btnWidthGrow;
    private ExtendedButton btnWidthShrink;
    private ExtendedButton btnLengthGrow;
    private ExtendedButton btnLengthShrink;
    private ExtendedButton btnHeightGrow;
    private ExtendedButton btnHeightShrink;
    private GuiTextBox txtZipName;
    private CustomButton btnScan;
    private ExtendedButton btnSet;

    public GuiStructureScanner(BlockPos blockPos, Level world, StructureScannerConfig config) {
        super("Structure Scanner");
        this.blockPos = blockPos;
        this.world = world;
        config.blockPos = blockPos;
        this.config = this.findExistingConfig(config);
    }

    @Override
    protected void Initialize() {
        super.Initialize();
        this.config.direction = (Direction)this.world.m_8055_(this.blockPos).m_61143_((Property)BlockStructureScanner.FACING);
        Tuple<Integer, Integer> adjustedXYValues = this.getAdjustedXYValue();
        int adjustedX = adjustedXYValues.getFirst();
        int adjustedY = adjustedXYValues.getSecond();
        this.btnStartingPositionMoveDown = this.createAndAddButton(adjustedX + 33, adjustedY + 50, 25, 20, "^", null);
        this.btnStartingPositionMoveDown.fontScale = 1.4f;
        this.btnStartingPositionMoveLeft = this.createAndAddButton(adjustedX + 20, adjustedY + 75, 25, 20, "<", null);
        this.btnStartingPositionMoveLeft.fontScale = 1.3f;
        this.btnStartingPositionMoveRight = this.createAndAddButton(adjustedX + 47, adjustedY + 75, 25, 20, ">", null);
        this.btnStartingPositionMoveRight.fontScale = 1.3f;
        this.btnStartingPositionMoveUp = this.createAndAddButton(adjustedX + 33, adjustedY + 100, 25, 20, "v", null);
        this.btnLengthShrink = this.createAndAddButton(adjustedX + 120, adjustedY + 30, 25, 20, "v", null);
        this.btnLengthGrow = this.createAndAddButton(adjustedX + 147, adjustedY + 30, 25, 20, "^", null);
        this.btnLengthGrow.fontScale = 1.4f;
        this.btnWidthShrink = this.createAndAddButton(adjustedX + 200, adjustedY + 30, 25, 20, "v", null);
        this.btnWidthGrow = this.createAndAddButton(adjustedX + 227, adjustedY + 30, 25, 20, "^", null);
        this.btnWidthGrow.fontScale = 1.4f;
        this.btnHeightShrink = this.createAndAddButton(adjustedX + 270, adjustedY + 30, 25, 20, "v", null);
        this.btnHeightGrow = this.createAndAddButton(adjustedX + 297, adjustedY + 30, 25, 20, "^", null);
        this.btnHeightGrow.fontScale = 1.4f;
        this.txtZipName = new GuiTextBox(this.getMinecraft().f_91062_, adjustedX + 120, adjustedY + 75, 150, 20, (Component)Component.m_237113_((String)""));
        if (this.config.structureZipName == null || this.config.structureZipName.trim().equals("")) {
            this.txtZipName.setValue("Structure Name Here");
        } else {
            this.txtZipName.setValue(this.config.structureZipName);
        }
        this.txtZipName.setMaxLength(128);
        this.txtZipName.setBordered(true);
        this.txtZipName.backgroundColor = Color.WHITE.getRGB();
        this.txtZipName.setTextColor(Color.DARK_GRAY.getRGB());
        this.txtZipName.drawsTextShadow = false;
        this.m_142416_(this.txtZipName);
        this.btnSet = this.createAndAddButton(adjustedX + 25, adjustedY + 140, 90, 20, "Set And Close", null);
        this.btnScan = this.createAndAddCustomButton(adjustedX + 200, adjustedY + 140, 90, 20, "Scan");
    }

    @Override
    protected void preButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawControlBackground(matrixStack, x, y + 15, 350, 250);
    }

    @Override
    protected void postButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(matrixStack, "Starting Position", x + 15, y + 20, this.textColor);
        this.drawString(matrixStack, "Left: " + this.config.blocksToTheLeft + " Down: " + -this.config.blocksDown, x + 15, y + 35, this.textColor);
        this.drawString(matrixStack, "Length: " + this.config.blocksLong, x + 120, y + 20, this.textColor);
        this.drawString(matrixStack, "Width: " + this.config.blocksWide, x + 200, y + 20, this.textColor);
        this.drawString(matrixStack, "Height: " + this.config.blocksTall, x + 270, y + 20, this.textColor);
        this.drawString(matrixStack, "Name", x + 120, y + 60, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.config.structureZipName = this.txtZipName.getValue();
        if (this.config.structureZipName.trim().equals("")) {
            this.config.structureZipName = "Structure Name Here";
        }
        this.config.structureZipName = this.config.structureZipName.toLowerCase().trim().replace(' ', '_');
        if (button == this.btnScan) {
            this.sendScanPacket();
            this.closeScreen();
        } else if (button == this.btnSet) {
            this.closeScreen();
        } else {
            if (button == this.btnStartingPositionMoveLeft) {
                ++this.config.blocksToTheLeft;
            }
            if (button == this.btnStartingPositionMoveRight) {
                --this.config.blocksToTheLeft;
            }
            if (button == this.btnStartingPositionMoveDown) {
                --this.config.blocksDown;
            }
            if (button == this.btnStartingPositionMoveUp) {
                ++this.config.blocksDown;
            }
            if (button == this.btnWidthGrow) {
                ++this.config.blocksWide;
            }
            if (button == this.btnWidthShrink) {
                --this.config.blocksWide;
            }
            if (button == this.btnLengthGrow) {
                ++this.config.blocksLong;
            }
            if (button == this.btnLengthShrink) {
                --this.config.blocksLong;
            }
            if (button == this.btnHeightGrow) {
                ++this.config.blocksTall;
            }
            if (button == this.btnHeightShrink) {
                --this.config.blocksTall;
            }
            this.sendUpdatePacket();
        }
    }

    private void sendUpdatePacket() {
        StructureScannerSyncMessage messagePacket = Utils.createGenericMessage(this.config.GetCompoundTag(), StructureScannerSyncMessage.class);
        Prefab.network.sendToServer((Object)messagePacket);
    }

    private void sendScanPacket() {
        StructureScannerActionMessage messagePacket = Utils.createGenericMessage(this.config.GetCompoundTag(), StructureScannerActionMessage.class);
        Prefab.network.sendToServer((Object)messagePacket);
    }

    private StructureScannerConfig findExistingConfig(StructureScannerConfig config) {
        boolean foundExistingConfig = false;
        for (StructureScannerConfig globalConfig : Prefab.proxy.structureScanners) {
            if (globalConfig.blockPos.m_123341_() != config.blockPos.m_123341_() || globalConfig.blockPos.m_123343_() != config.blockPos.m_123343_() || globalConfig.blockPos.m_123342_() != config.blockPos.m_123342_()) continue;
            foundExistingConfig = true;
            config = globalConfig;
            break;
        }
        if (!foundExistingConfig) {
            Prefab.proxy.structureScanners.add(config);
        }
        return config;
    }
}

