/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab;

import com.wuest.prefab.proxy.messages.TagMessage;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.text.WordUtils;

public class Utils {
    public static String[] WrapString(String value) {
        return Utils.WrapString(value, 50);
    }

    public static String[] WrapString(String value, int width) {
        String result = WordUtils.wrap((String)value, (int)width);
        String[] results = result.split("\n");
        String[] returnValue = new String[results.length];
        for (int i = 0; i < results.length; ++i) {
            returnValue[i] = results[i].trim();
        }
        return returnValue;
    }

    public static ArrayList<MutableComponent> WrapStringToLiterals(String value) {
        return Utils.WrapStringToLiterals(value, 50);
    }

    public static MutableComponent createTextComponent(String value) {
        return Component.m_237113_((String)value);
    }

    public static ArrayList<MutableComponent> WrapStringToLiterals(String value, int width) {
        String[] values = Utils.WrapString(value, width);
        ArrayList<MutableComponent> returnValue = new ArrayList<MutableComponent>();
        for (String stringValue : values) {
            returnValue.add(Utils.createTextComponent(stringValue));
        }
        return returnValue;
    }

    public static TagMessage createMessage(CompoundTag tag) {
        return new TagMessage(tag);
    }

    public static <T extends TagMessage> T createGenericMessage(CompoundTag tag, Class<T> tClass) {
        try {
            return (T)((TagMessage)tClass.getConstructor(CompoundTag.class).newInstance(tag));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StructureTagMessage createStructureMessage(CompoundTag tag, StructureTagMessage.EnumStructureConfiguration structureConfiguration) {
        return new StructureTagMessage(tag, structureConfiguration);
    }

    public static Direction getDirectionByName(String name) {
        if (!StringUtil.isNullOrEmpty((String)name)) {
            for (Direction direction : Direction.values()) {
                if (!direction.m_7912_().equalsIgnoreCase(name)) continue;
                return direction;
            }
        }
        return Direction.NORTH;
    }

    public static ArrayList<Block> getBlocksWithTagLocation(ResourceLocation resourceLocation) {
        TagKey tags = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)resourceLocation);
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Holder blockHolder : Registry.f_122824_.m_206058_(tags)) {
            blocks.add((Block)blockHolder.m_203334_());
        }
        return blocks;
    }

    public static ArrayList<Block> getBlocksWithTagKey(TagKey<Block> tagKey) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Holder blockHolder : Registry.f_122824_.m_206058_(tagKey)) {
            blocks.add((Block)blockHolder.m_203334_());
        }
        return blocks;
    }

    public static boolean doesBlockHaveTag(Block block, ResourceLocation location) {
        ResourceLocation blockKey = Registry.f_122824_.m_7981_((Object)block);
        TagKey tags = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)location);
        for (Holder blockHolder : Registry.f_122824_.m_206058_(tags)) {
            if (!blockHolder.m_203373_(blockKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesBlockStateHaveTag(BlockState blockState, ResourceLocation location) {
        for (TagKey tagKey : blockState.m_204343_().toList()) {
            if (!tagKey.f_203868_().toString().equalsIgnoreCase(location.toString())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ItemStack> getItemStacksWithTag(ResourceLocation resourceLocation) {
        TagKey tags = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)resourceLocation);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Holder holder : Registry.f_122827_.m_206058_(tags)) {
            itemStacks.add(new ItemStack((ItemLike)holder.m_203334_()));
        }
        return itemStacks;
    }

    public static boolean doesItemHaveTag(Item item, ResourceLocation location) {
        ResourceLocation blockKey = Registry.f_122827_.m_7981_((Object)item);
        TagKey tags = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)location);
        for (Holder blockHolder : Registry.f_122827_.m_206058_(tags)) {
            if (!blockHolder.m_203373_(blockKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesItemStackHaveTag(ItemStack itemStack, ResourceLocation location) {
        for (TagKey tagKey : itemStack.m_204131_().toList()) {
            if (!tagKey.f_203868_().toString().equalsIgnoreCase(location.toString())) continue;
            return true;
        }
        return false;
    }
}

