/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.container.PelicanMenu;
import net.pavocado.exoticbirds.entity.AbstractSwimmingBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public class PelicanEntity
extends AbstractSwimmingBirdEntity
implements MenuProvider {
    private static final EntityDataAccessor<Integer> DATA_RING_COLOR = SynchedEntityData.m_135353_(PelicanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_});
    private static final Ingredient TAMING_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42530_, Items.f_42531_});
    private static final Ingredient TEMPTING_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_, Items.f_42530_, Items.f_42531_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/pelican/pelican_american.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/pelican/pelican_australian.png"));
    });
    private static final float START_HEALTH = 14.0f;
    private static final float TAME_HEALTH = 20.0f;
    public ItemStackHandler pelicanInventory;
    private LazyOptional<?> itemHandler = null;

    public PelicanEntity(EntityType<? extends PelicanEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.PELICAN_EGG.get()), BIRD_TEXTURES.size(), true, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_7105_(false);
        this.initInventory();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new PelicanTemptGoal(this, 1.0, TEMPTING_ITEMS, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FishUpFishGoal());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RING_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.85f : size.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public PelicanEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        PelicanEntity pelican = (PelicanEntity)((EntityType)ExoticBirdsEntities.PELICAN.get()).m_20615_((Level)serverLevel);
        if (pelican != null) {
            pelican.setVariant(this.getChildVariant());
            UUID uuid = this.m_21805_();
            if (uuid != null) {
                pelican.m_21816_(uuid);
                pelican.m_7105_(true);
            }
        }
        return pelican;
    }

    @Override
    public boolean m_7848_(Animal animal) {
        if (super.m_7848_(animal)) {
            return this.m_21824_() && ((PelicanEntity)animal).m_21824_() && !((PelicanEntity)animal).m_21825_();
        }
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public DyeColor getRingColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_RING_COLOR)));
    }

    public void setRingColor(DyeColor colour) {
        this.f_19804_.m_135381_(DATA_RING_COLOR, (Object)colour.m_41060_());
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.pelicanInventory.serializeNBT());
        tag.m_128344_("RingColor", (byte)this.getRingColor().m_41060_());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.pelicanInventory.deserializeNBT(tag.m_128469_("Inventory"));
        if (tag.m_128425_("RingColor", 99)) {
            this.setRingColor(DyeColor.m_41053_((int)tag.m_128451_("RingColor")));
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, damage);
    }

    public void m_7105_(boolean tame) {
        super.m_7105_(tame);
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        if (tame) {
            if (healthAttribute != null) {
                healthAttribute.m_22100_(20.0);
            }
            this.m_21153_(20.0f);
            this.setRingColor(DyeColor.RED);
        } else if (healthAttribute != null) {
            healthAttribute.m_22100_(14.0);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || TAMING_ITEMS.test(itemstack) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (FOOD_ITEMS.test(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(6.0f);
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                if (player.m_36341_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
                    this.openGUI(player);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                InteractionResult interactionresult = super.m_6071_(player, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            DyeColor dyecolor = ((DyeItem)item).m_41089_();
            if (dyecolor != this.getRingColor()) {
                this.setRingColor(dyecolor);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (TAMING_ITEMS.test(itemstack)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void fishUpItem() {
        if (!this.f_19853_.m_5776_() && this.pelicanInventory != null && !this.m_6162_() && ((Boolean)ExoticBirdsCommonConfig.allowPelicanScavenge.get()).booleanValue()) {
            List<ItemStack> fish = PelicanEntity.getFishedUpItem(this);
            block0: for (ItemStack stack : fish) {
                for (int i = 0; i < this.pelicanInventory.getSlots(); ++i) {
                    ItemStack remainder = this.pelicanInventory.insertItem(i, stack, false);
                    if (!remainder.m_41619_()) continue;
                    this.m_5496_(SoundEvents.f_12279_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    continue block0;
                }
            }
        }
    }

    protected void m_5907_() {
        if (this.pelicanInventory != null) {
            for (int i = 0; i < this.pelicanInventory.getSlots(); ++i) {
                ItemStack itemstack = this.pelicanInventory.getStackInSlot(i);
                if (itemstack.m_41619_()) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private void openGUI(Player player) {
        if (!this.f_19853_.m_5776_() && this.m_21824_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
        }
    }

    @Nonnull
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new PelicanMenu(windowId, inventory, this);
    }

    protected void initInventory() {
        this.pelicanInventory = new ItemStackHandler(5);
        this.itemHandler = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.pelicanInventory, 0, 5));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (this.m_6084_() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    private static List<ItemStack> getFishedUpItem(PelicanEntity entity) {
        if (entity.f_19853_.m_7654_() != null) {
            LootTable loottable = entity.f_19853_.m_7654_().m_129898_().m_79217_(BuiltInLootTables.f_78723_);
            return loottable.m_230922_(new LootContext.Builder((ServerLevel)entity.f_19853_).m_230911_(entity.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81410_));
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(TEMPTING_ITEMS.m_43908_());
    }

    @Override
    public List<ItemStack> getTamingItems() {
        return Arrays.asList(TAMING_ITEMS.m_43908_());
    }

    static class PelicanTemptGoal
    extends TemptGoal {
        private final PelicanEntity pelican;

        public PelicanTemptGoal(PelicanEntity pelicanIn, double speedIn, Ingredient temptItemsIn, boolean scaredByMovement) {
            super((PathfinderMob)pelicanIn, speedIn, temptItemsIn, scaredByMovement);
            this.pelican = pelicanIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.pelican.m_21824_();
        }
    }

    class FishUpFishGoal
    extends Goal {
        FishUpFishGoal() {
        }

        public boolean m_8036_() {
            return PelicanEntity.this.m_21824_() && PelicanEntity.this.m_217043_().m_188503_(FishUpFishGoal.m_186073_((int)2000)) == 0;
        }

        public void m_8056_() {
            PelicanEntity.this.fishUpItem();
        }
    }
}

