/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.pavocado.exoticbirds.block.NestBlock;
import net.pavocado.exoticbirds.blockentity.NestBlockEntity;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockTags;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public abstract class AbstractBirdEntity
extends TamableAnimal {
    protected static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(AbstractBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemStack egg;
    protected final int numberOfTypes;
    protected boolean canFloat;
    private final boolean isGendered;
    protected boolean hasChildTextures;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime = this.f_19796_.m_188503_(6000) + (Integer)ExoticBirdsCommonConfig.baseEggLayRate.get();

    public AbstractBirdEntity(EntityType<? extends AbstractBirdEntity> typeIn, Level levelIn, ItemStack eggIn, int typeCountIn, boolean canFloatIn, boolean genderedIn) {
        super(typeIn, levelIn);
        this.egg = eggIn;
        this.numberOfTypes = typeCountIn;
        this.canFloat = canFloatIn;
        this.isGendered = genderedIn;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (spawnData instanceof BirdGroupData) {
            BirdGroupData groupData = (BirdGroupData)((Object)spawnData);
            this.setVariant(groupData.flockLeader.currentVariant());
            this.setVariant(this.getChildVariant());
        } else {
            spawnData = new BirdGroupData(this, true);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public MobType m_6336_() {
        return ExoticBirdsEntities.BIRD;
    }

    public int getVariantCount() {
        return this.numberOfTypes;
    }

    public int currentVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID)), (int)0, (int)this.numberOfTypes);
    }

    public void setVariant(int variantIn) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variantIn);
    }

    public int getRandomVariant() {
        return this.f_19796_.m_188503_(this.numberOfTypes);
    }

    public int getChildVariant() {
        if (this.isGendered) {
            return 2 * (this.currentVariant() / 2) + this.f_19796_.m_188503_(2);
        }
        return this.currentVariant();
    }

    public final int getChildVariantIgnoreGender() {
        if (this.isGendered) {
            return 2 * (this.getChildVariant() / 2);
        }
        return this.getChildVariant();
    }

    public final ResourceLocation getBirdTypeName() {
        return this.getBirdTypeName(this.currentVariant(), false);
    }

    public final ResourceLocation getBirdTypeName(int variant, boolean ignoreChild) {
        if (this.m_6162_() && this.hasChildTextures && !ignoreChild) {
            return this.getBirdTypeNameForChild();
        }
        return this.getEntityTextures().get(variant);
    }

    private ResourceLocation getBirdTypeNameForChild() {
        String resourceName = this.getEntityTextures().get(this.currentVariant()).toString().replace("_male", "").replace("_female", "").replace(".png", "_chick.png");
        return new ResourceLocation(resourceName);
    }

    protected abstract Map<Integer, ResourceLocation> getEntityTextures();

    public ItemStack getEgg() {
        return this.egg;
    }

    public Gender getGender(int variant) {
        if (this.isGendered) {
            return variant % 2 == 0 ? Gender.MALE : Gender.FEMALE;
        }
        return Gender.NONE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        this.performFlap();
    }

    protected void performFlap() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.f_19861_ ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0 && this.canFloat) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.m_6084_() && !this.m_6162_() && this.canLayEggs()) {
            if (this.eggTime > 0) {
                --this.eggTime;
                if (this.eggTime < 500 && this.eggTime % 5 == 0) {
                    this.f_19853_.m_7605_((Entity)this, (byte)42);
                }
            }
            if (this.eggTime == 0) {
                BlockEntity blockEntity;
                Level level = this.f_19853_;
                ItemStack eggStack = this.layEgg();
                boolean hasLaidEgg = false;
                BlockState feetState = this.m_146900_();
                if (feetState.m_60713_((Block)ExoticBirdsBlocks.NEST.get()) && (Integer)feetState.m_61143_((Property)NestBlock.EGGS) < 3 && (blockEntity = level.m_7702_(this.m_20183_())) instanceof NestBlockEntity) {
                    hasLaidEgg = ((NestBlockEntity)blockEntity).insertItem(eggStack);
                    this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
                }
                if (!hasLaidEgg && ((Boolean)ExoticBirdsCommonConfig.allowLayEggs.get()).booleanValue()) {
                    this.m_19983_(eggStack);
                    this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
                }
            }
        }
    }

    public boolean m_21532_() {
        return super.m_21532_() || (Boolean)ExoticBirdsCommonConfig.allowBirdDespawning.get() == false;
    }

    public ItemStack layEgg() {
        ItemStack eggStack = this.egg.m_41777_();
        CompoundTag tag = eggStack.m_41698_("EggValues");
        tag.m_128405_("Variant", this.getChildVariantIgnoreGender());
        this.eggTime = this.f_19796_.m_188503_(6000) + (Integer)ExoticBirdsCommonConfig.baseEggLayRate.get();
        return eggStack;
    }

    public boolean canLayEggs() {
        return !this.isGendered || this.currentVariant() == 1;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_142535_(float p_148875_, float p_148876_, DamageSource p_148877_) {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.currentVariant());
        tag.m_128405_("EggLayTime", this.eggTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
        if (tag.m_128441_("EggLayTime")) {
            this.eggTime = tag.m_128451_("EggLayTime");
        }
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (animal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (this.m_27593_() && animal.m_27593_()) {
            if (this.isGendered) {
                int otherVariant = ((AbstractBirdEntity)animal).currentVariant();
                return otherVariant / 2 == this.currentVariant() / 2 && otherVariant != this.currentVariant();
            }
            return ((AbstractBirdEntity)animal).currentVariant() == this.currentVariant();
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_148993_, AgeableMob p_148994_) {
        return null;
    }

    public final Component getTranslatedVariantName(int variant, boolean ignoreGender) {
        String resourceName = this.getBirdTypeName(variant, true).toString();
        resourceName = resourceName.substring(resourceName.lastIndexOf(47) + 1).replace(".png", "");
        Gender gender = this.getGender(variant);
        if (gender != Gender.NONE) {
            resourceName = resourceName.replace("_male", "").replace("_female", "");
            MutableComponent speciesName = Component.m_237115_((String)("exoticbirds.species." + resourceName));
            if (ignoreGender) {
                return speciesName;
            }
            String genderString = gender == Gender.MALE ? "male" : "female";
            MutableComponent genderName = Component.m_237115_((String)("gender.exoticbirds." + genderString));
            return Component.m_237110_((String)"book.exoticbirds.name_with_gender", (Object[])new Object[]{speciesName, genderName});
        }
        return Component.m_237115_((String)("exoticbirds.species." + resourceName));
    }

    public Component getTranslatedFamilyName() {
        return Component.m_237115_((String)("exoticbirds.family." + this.m_6095_().m_20675_().replace("entity.exoticbirds.", "")));
    }

    public void m_7822_(byte b) {
        if (b == 42) {
            this.addParticlesAroundSelf();
        } else {
            super.m_7822_(b);
        }
    }

    protected void addParticlesAroundSelf() {
        for (int i = 0; i < 1; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20208_(1.0), this.m_20227_(this.f_19796_.m_188500_() * 0.2), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public SoundEvent getBirdcageSound() {
        return this.m_7515_();
    }

    public List<ItemStack> getTamingItems() {
        return new ArrayList<ItemStack>();
    }

    public List<ItemStack> getTemptingItems() {
        return new ArrayList<ItemStack>();
    }

    public boolean m_5957_() {
        return super.m_5957_() && (!this.canLayEggs() || this.eggTime >= 500);
    }

    public static boolean checkDesertBirdSpawnRules(EntityType<? extends AbstractBirdEntity> p_218512_, LevelAccessor p_218513_, MobSpawnType p_218514_, BlockPos p_218515_, RandomSource p_218516_) {
        return p_218513_.m_8055_(p_218515_.m_7495_()).m_204336_(ExoticBirdsBlockTags.DESERT_BIRDS_SPAWNABLE_ON) && AbstractBirdEntity.m_186209_((BlockAndTintGetter)p_218513_, (BlockPos)p_218515_);
    }

    public static boolean checkSwampBirdSpawnRules(EntityType<? extends AbstractBirdEntity> p_218512_, LevelAccessor p_218513_, MobSpawnType p_218514_, BlockPos p_218515_, RandomSource p_218516_) {
        return AbstractBirdEntity.m_186209_((BlockAndTintGetter)p_218513_, (BlockPos)p_218515_) && (p_218513_.m_8055_(p_218515_.m_7495_()).m_204336_(ExoticBirdsBlockTags.SWAMP_BIRDS_SPAWNABLE_ON) || p_218513_.m_6425_(p_218515_.m_7495_()).m_205070_(FluidTags.f_13131_) && p_218513_.m_8055_(p_218515_).m_60795_());
    }

    public static class BirdGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final AbstractBirdEntity flockLeader;

        public BirdGroupData(AbstractBirdEntity leader, boolean spawnBaby) {
            super(spawnBaby);
            this.flockLeader = leader;
            leader.setVariant(leader.getRandomVariant());
        }

        public BirdGroupData(AbstractBirdEntity leader, float spawnChance) {
            super(spawnChance);
            this.flockLeader = leader;
            leader.setVariant(leader.getRandomVariant());
        }
    }

    public static enum Gender {
        NONE,
        MALE,
        FEMALE;

    }
}

