/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.ToucanEntity;

@OnlyIn(value=Dist.CLIENT)
public class ToucanModel<T extends ToucanEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation TOUCAN_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "toucan"), "main");
    private final ModelPart head;
    private final ModelPart lowerBeak;
    private final ModelPart upperBeak;
    private final ModelPart lowerBody;
    private final ModelPart lowerTail;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart tail;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightFoot;
    private final ModelPart leftFoot;

    public ToucanModel(ModelPart part) {
        this.head = part.m_171324_("head");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.upperBeak = part.m_171324_("upperBeak");
        this.lowerBody = part.m_171324_("lowerBody");
        this.lowerTail = part.m_171324_("lowerTail");
        this.body = part.m_171324_("body");
        this.rightLeg = part.m_171324_("rightLeg");
        this.leftLeg = part.m_171324_("leftLeg");
        this.tail = part.m_171324_("tail");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftFoot = part.m_171324_("leftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)0.0f, (float)0.1115358f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(16, 23).m_171481_(-1.0f, -3.6f, -5.5f, 2.0f, 1.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)0.0f, (float)0.0174533f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-1.0f, -5.3f, -5.8f, 2.0f, 2.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)0.0f, (float)0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBody", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.5f, 1.0f, -0.8f, 3.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)18.6f, (float)0.0f, (float)-0.0986266f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerTail", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)21.3f, (float)3.0f, (float)-0.2974289f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)18.8f, (float)0.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171423_((float)-0.8f, (float)22.0f, (float)1.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.m_171423_((float)0.8f, (float)22.0f, (float)1.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 9).m_171481_(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)20.6f, (float)3.0f, (float)-0.5205006f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(20, -2).m_171481_(0.0f, 0.0f, -2.0f, 0.0f, 4.0f, 6.0f), PartPose.m_171423_((float)-2.0f, (float)18.8f, (float)1.0f, (float)0.0872665f, (float)0.0349066f, (float)0.2268928f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(20, -6).m_171481_(0.0f, 0.0f, -2.0f, 0.0f, 4.0f, 6.0f), PartPose.m_171423_((float)2.0f, (float)18.8f, (float)1.0f, (float)0.0872665f, (float)0.0349066f, (float)-0.2268928f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(8, 21).m_171481_(-1.0f, 2.0f, -2.3f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)-0.8f, (float)22.0f, (float)1.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(8, 17).m_171481_(-1.0f, 2.0f, -2.3f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)0.8f, (float)22.0f, (float)1.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.lowerBeak, (Object)this.upperBeak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.lowerBody, (Object)this.lowerTail, (Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.tail, (Object)this.rightWing, (Object)this.leftWing, (Object)this.rightFoot, (Object)this.leftFoot);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netheadYaw, float headPitch) {
        this.head.f_104203_ = -(headPitch / 57.295776f);
        this.head.f_104204_ = netheadYaw / 57.295776f;
        this.lowerBeak.f_104203_ = this.head.f_104203_;
        this.lowerBeak.f_104204_ = this.head.f_104204_;
        this.upperBeak.f_104203_ = this.head.f_104203_;
        this.upperBeak.f_104204_ = this.head.f_104204_;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
        if (entityIn.m_20069_()) {
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 5.0f;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 5.0f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 5.0f;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 5.0f;
        } else if (!((AbstractFlyingBirdEntity)((Object)entityIn)).m_29443_()) {
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.55f, 0.55f, 0.55f);
            stack.m_85837_(0.0, (double)1.2f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

