/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;

@OnlyIn(value=Dist.CLIENT)
public class SongbirdModel<T extends AbstractFlyingBirdEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation SONGBIRD_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "songbird"), "main");
    private final ModelPart tail;
    private final ModelPart body;
    private final ModelPart plumage;
    private final ModelPart upperBeak;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart lowerBeak;
    private final ModelPart rightFoot;
    private final ModelPart leftAnkle;
    private final ModelPart rightAnkle;
    private final ModelPart leftFoot;
    private final ModelPart belly;
    private final ModelPart head;

    public SongbirdModel(ModelPart part) {
        this.tail = part.m_171324_("tail");
        this.body = part.m_171324_("body");
        this.plumage = part.m_171324_("plumage");
        this.upperBeak = part.m_171324_("upperBeak");
        this.leftWing = part.m_171324_("leftWing");
        this.rightWing = part.m_171324_("rightWing");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftAnkle = part.m_171324_("leftAnkle");
        this.rightAnkle = part.m_171324_("rightAnkle");
        this.leftFoot = part.m_171324_("leftFoot");
        this.belly = part.m_171324_("belly");
        this.head = part.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)20.7f, (float)1.0f, (float)-0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)18.2f, (float)-4.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("plumage", CubeListBuilder.m_171558_().m_171514_(22, 25).m_171481_(-1.0f, -5.2f, -2.5f, 2.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)18.2f, (float)-4.0f, (float)-0.5189514f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(-1.0f, -2.5f, -2.5f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)-4.0f, (float)0.4014257f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 7.0f), PartPose.m_171423_((float)2.0f, (float)17.2f, (float)-3.0f, (float)-0.2094395f, (float)-0.0349066f, (float)-0.2617994f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 7.0f), PartPose.m_171423_((float)-2.0f, (float)17.2f, (float)-3.0f, (float)-0.2094395f, (float)0.0349066f, (float)0.2617994f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(22, 4).m_171481_(-1.0f, -1.5f, -3.2f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)-4.0f, (float)0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(-3, 22).m_171481_(-1.0f, 3.2f, -1.6f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)20.8f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftAnkle", CubeListBuilder.m_171558_().m_171514_(1, 0).m_171481_(-0.6f, 0.2f, 0.8f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)20.8f, (float)-2.0f, (float)-0.4461433f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightAnkle", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-0.4f, 0.2f, 0.8f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)20.8f, (float)-2.0f, (float)-0.4461433f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(-3, 19).m_171481_(-1.0f, 3.2f, -1.6f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)1.0f, (float)20.8f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(15, 18).m_171481_(-1.5f, -2.8f, -1.0f, 3.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-2.0f, (float)1.414336f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(14, 11).m_171481_(-1.5f, -2.8f, -1.0f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)18.2f, (float)-4.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.upperBeak, (Object)this.lowerBeak, (Object)this.head, (Object)this.plumage);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.tail, (Object)this.body, (Object)this.leftWing, (Object)this.rightWing, (Object)this.rightFoot, (Object)this.leftAnkle, (Object)this.rightAnkle, (Object)this.leftFoot, (Object)this.belly);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((AbstractFlyingBirdEntity)((Object)entityIn)).m_29443_()) {
            this.rightAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.4461433f;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.4461433f;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.rightWing.f_104205_ = ageInTicks + 0.2617994f;
        this.leftWing.f_104205_ = -ageInTicks - 0.2617994f;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.6f, 0.6f, 0.6f);
            stack.m_85837_(0.0, 1.0, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

