/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui.book;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.pavocado.exoticbirds.client.gui.BirdBookScreen;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import org.apache.commons.compress.utils.Lists;

public class CachedEntry {
    private final LivingEntity cachedEntity;
    private VariantEntry variant;
    private final List<VariantEntry> birdVariants = Lists.newArrayList();
    private List<ItemStack> temptingItems = Lists.newArrayList();
    private List<ItemStack> tamingItems = Lists.newArrayList();
    private int discoveredVariants = 0;

    public CachedEntry(LivingEntity entity) {
        this.cachedEntity = entity;
        this.setupVariantEntries(entity);
    }

    private void setupVariantEntries(LivingEntity entity) {
        int variants = 1;
        if (entity instanceof AbstractBirdEntity) {
            AbstractBirdEntity birdEntity = (AbstractBirdEntity)entity;
            variants = birdEntity.getVariantCount();
            this.tamingItems = birdEntity.getTamingItems();
            this.temptingItems = birdEntity.getTemptingItems();
        }
        boolean firstUnlocked = false;
        this.discoveredVariants = 0;
        this.birdVariants.clear();
        for (int i = 0; i < variants; ++i) {
            VariantEntry variantEntry = new VariantEntry(entity, i, BirdBookScreen.isEntityUnlocked(entity.m_6095_(), i));
            if (variantEntry.unlocked) {
                ++this.discoveredVariants;
                if (!firstUnlocked) {
                    this.setVariant(variantEntry);
                    firstUnlocked = true;
                }
            }
            this.birdVariants.add(variantEntry);
        }
        if (!firstUnlocked) {
            this.setVariant(this.birdVariants.get(0));
        }
    }

    public List<VariantEntry> getBirdVariantList() {
        return this.birdVariants;
    }

    public final LivingEntity getCachedEntity() {
        return this.cachedEntity;
    }

    public int getDiscoveredVariants() {
        return this.discoveredVariants;
    }

    public void setVariant(VariantEntry variantEntry) {
        LivingEntity livingEntity = this.cachedEntity;
        if (livingEntity instanceof AbstractBirdEntity) {
            AbstractBirdEntity abstractBird = (AbstractBirdEntity)livingEntity;
            abstractBird.setVariant(variantEntry.variant);
        }
        this.variant = variantEntry;
    }

    public final VariantEntry getVariant() {
        return this.variant;
    }

    public List<ItemStack> getTemptingItems() {
        return this.temptingItems;
    }

    public List<ItemStack> getTamingItems() {
        return this.tamingItems;
    }

    public static class VariantEntry {
        private final int variant;
        private final boolean unlocked;
        private final Component variantName;

        public VariantEntry(LivingEntity entityLiving, int variant, boolean isUnlocked) {
            this.variant = variant;
            this.unlocked = isUnlocked;
            this.variantName = this.getVariantName(entityLiving, variant, isUnlocked);
        }

        private Component getVariantName(LivingEntity entityLiving, int variant, boolean isUnlocked) {
            if (entityLiving instanceof AbstractBirdEntity) {
                AbstractBirdEntity abstractBird = (AbstractBirdEntity)entityLiving;
                if (isUnlocked) {
                    return abstractBird.getTranslatedVariantName(variant, false);
                }
            }
            return Component.m_237113_((String)"???");
        }

        public boolean isVariantUnlocked() {
            return this.unlocked;
        }

        public Component getTranslatedName() {
            return this.variantName;
        }
    }
}

