/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.block.IncubatorBlock;
import net.pavocado.exoticbirds.container.IncubatorMenu;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.item.BirdEggItem;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = IntStream.range(0, 15).toArray();
    public static final int totalHeatTime = 500;
    private int incubationProgress;
    private int litTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int i) {
            return switch (i) {
                case 0 -> IncubatorBlockEntity.this.litTime;
                case 1 -> IncubatorBlockEntity.this.incubationProgress;
                default -> 0;
            };
        }

        public void m_8050_(int i, int val) {
            switch (i) {
                case 0: {
                    IncubatorBlockEntity.this.litTime = val;
                    break;
                }
                case 1: {
                    IncubatorBlockEntity.this.incubationProgress = val;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public final ItemStackHandler inventory = new ItemStackHandler(15){

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return !stack.m_41619_() && stack.m_41720_() == Items.f_42593_;
            }
            return !stack.m_41619_() && stack.m_41720_() instanceof BirdEggItem;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            IncubatorBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown;
    private LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalOther;

    public IncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExoticBirdsBlockEntities.EGG_INCUBATOR.get(), pos, state);
        this.createCaps();
    }

    public int[] m_7071_(Direction facing) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction facing) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.m_41720_() == Items.f_42593_;
        }
        return stack.m_41720_() instanceof BirdEggItem && this.m_8020_(slot).m_41619_();
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction facing) {
        return true;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)((IncubatorBlock)((Object)ExoticBirdsBlocks.EGG_INCUBATOR.get())).m_7705_());
    }

    protected AbstractContainerMenu m_6555_(int val, Inventory inventory) {
        return new IncubatorMenu(val, inventory, this, this.dataAccess);
    }

    public int m_6643_() {
        return 15;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemstack = this.m_8020_(slot);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.setStackInSlot(slot, stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !flag) {
            this.incubationProgress = 0;
            this.m_6596_();
        }
    }

    protected NonNullList<ItemStack> getItems() {
        NonNullList stackList = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            stackList.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return stackList;
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, IncubatorBlockEntity entity) {
        boolean stateChange = false;
        boolean isLit = entity.isLit();
        if (isLit) {
            --entity.litTime;
        }
        if (entity.canIncubate()) {
            if (!entity.isLit() && entity.burnFuel()) {
                stateChange = true;
            }
            if (isLit) {
                ++entity.incubationProgress;
                if (entity.incubationProgress == 500) {
                    entity.incubationProgress = 0;
                    entity.incubateEggs();
                }
            } else if (entity.incubationProgress > 0) {
                entity.incubationProgress = Mth.m_14045_((int)(entity.incubationProgress - 2), (int)0, (int)500);
            }
        } else {
            entity.incubationProgress = 0;
        }
        if (isLit != entity.isLit()) {
            stateChange = true;
            state = (BlockState)state.m_61124_((Property)IncubatorBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (stateChange) {
            IncubatorBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean canIncubate() {
        int filledSpaces = 0;
        for (int i = 1; i < 15; ++i) {
            ItemStack currentEgg = this.inventory.getStackInSlot(i).m_41777_();
            if (currentEgg.m_41619_() || !(currentEgg.m_41720_() instanceof BirdEggItem) || !BirdEggItem.canIncubate(currentEgg, 100)) continue;
            ++filledSpaces;
        }
        return filledSpaces > 0;
    }

    public void incubateEggs() {
        for (int i = 1; i < 15; ++i) {
            ItemStack eggStack = this.inventory.getStackInSlot(i);
            if (eggStack.m_41619_() || !(eggStack.m_41720_() instanceof BirdEggItem)) continue;
            CompoundTag compoundnbt = eggStack.m_41698_("EggValues");
            if (compoundnbt.m_128441_("SpawnChance")) {
                int spawnChance = compoundnbt.m_128451_("SpawnChance");
                compoundnbt.m_128405_("SpawnChance", Math.min(spawnChance + 10, 100));
            } else {
                compoundnbt.m_128405_("SpawnChance", 40);
            }
            this.inventory.setStackInSlot(i, eggStack);
        }
    }

    private boolean burnFuel() {
        ItemStack fuelStack = this.inventory.getStackInSlot(0).m_41777_();
        if (!fuelStack.m_41619_()) {
            this.litTime = 500;
            if (fuelStack.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
            } else {
                fuelStack.m_41774_(1);
                this.inventory.setStackInSlot(0, fuelStack);
            }
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.litTime = tag.m_128451_("LitTime");
        this.incubationProgress = tag.m_128451_("IncubateTime");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("LitTime", this.litTime);
        tag.m_128405_("IncubateTime", this.incubationProgress);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public int getRedstoneSignal() {
        int currSize = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            currSize += this.inventory.getStackInSlot(i).m_41613_();
        }
        return Mth.m_14143_((float)((float)currSize / 78.0f * 15.0f));
    }

    private void createCaps() {
        this.inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 15){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                CompoundTag compoundnbt;
                ItemStack itemStack = super.extractItem(slot, amount, true);
                if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof BirdEggItem && (compoundnbt = itemStack.m_41698_("EggValues")).m_128441_("SpawnChance") && compoundnbt.m_128451_("SpawnChance") >= 100) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.f_41583_;
            }
        });
        this.inventoryCapabilityExternalOther = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 15));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> this.inventoryCapabilityExternalDown.cast();
                case Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> this.inventoryCapabilityExternalOther.cast();
            };
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapabilityExternalDown.invalidate();
        this.inventoryCapabilityExternalOther.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.createCaps();
    }
}

