/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.pavocado.exoticbirds.container.BirdhouseMenu;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.item.BirdEggItem;
import org.jetbrains.annotations.Nullable;

public class BirdhouseBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)15, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS_FOR_DOWN = IntStream.range(0, 15).toArray();
    private int cooldownTime = -1;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN});

    public BirdhouseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExoticBirdsBlockEntities.BIRDHOUSE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.cooldownTime = tag.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("TransferCooldown", this.cooldownTime);
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return new int[0];
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, @Nullable Direction p_19237_) {
        return false;
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return true;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.exoticbirds.birdhouse");
    }

    protected AbstractContainerMenu m_6555_(int val, Inventory inventory) {
        return new BirdhouseMenu(val, inventory, (Container)this);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BirdhouseBlockEntity entity) {
        if (entity.cooldownTime-- < 0) {
            AABB box = new AABB((double)pos.m_123341_() - 6.0, (double)pos.m_123342_() - 6.0, (double)pos.m_123343_() - 6.0, (double)pos.m_123341_() + 6.0, (double)pos.m_123342_() + 6.0, (double)pos.m_123343_() + 6.0);
            List list = level.m_6443_(ItemEntity.class, box, EntitySelector.f_20402_);
            for (ItemEntity item : list) {
                ItemStack suckedStack = item.m_32055_().m_41777_();
                for (int i = 0; i < entity.m_6643_() && !suckedStack.m_41619_(); ++i) {
                    suckedStack = BirdhouseBlockEntity.moveInStack(entity, suckedStack, i);
                }
                if (suckedStack.m_41619_()) {
                    item.m_146870_();
                    continue;
                }
                item.m_32045_(suckedStack);
            }
            entity.cooldownTime = 64;
        }
    }

    private static ItemStack moveInStack(BirdhouseBlockEntity entity, ItemStack suckedStack, int slot) {
        ItemStack stack = entity.m_8020_(slot);
        if (entity.m_7013_(slot, suckedStack)) {
            boolean hasAltered = false;
            if (stack.m_41619_()) {
                entity.m_6836_(slot, suckedStack);
                suckedStack = ItemStack.f_41583_;
                hasAltered = true;
            } else if (BirdhouseBlockEntity.canMergeItems(stack, suckedStack)) {
                int x = suckedStack.m_41741_() - stack.m_41613_();
                int j = Math.min(suckedStack.m_41613_(), x);
                suckedStack.m_41774_(j);
                stack.m_41769_(j);
                boolean bl = hasAltered = j > 0;
            }
            if (hasAltered) {
                entity.m_6596_();
            }
        }
        return suckedStack;
    }

    private static boolean canMergeItems(ItemStack p_59345_, ItemStack p_59346_) {
        if (!p_59345_.m_150930_(p_59346_.m_41720_())) {
            return false;
        }
        if (p_59345_.m_41773_() != p_59346_.m_41773_()) {
            return false;
        }
        if (p_59345_.m_41613_() > p_59345_.m_41741_()) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)p_59345_, (ItemStack)p_59346_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            return item == ExoticBirdsItems.MYSTERY_EGG.get() || item == Items.f_42521_ || item instanceof BirdEggItem;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == Direction.DOWN) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN});
    }
}

