/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.capabilities.BirdTracking;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.AbstractPhoenixEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.item.BirdBookItem;

@Mod.EventBusSubscriber(modid="exoticbirds", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    @SubscribeEvent
    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.register(BirdTracking.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            BirdTrackingProvider trackingProvider = new BirdTrackingProvider();
            event.addCapability(new ResourceLocation("exoticbirds", "bird_tracking"), (ICapabilityProvider)trackingProvider);
        }
    }

    @SubscribeEvent
    public static void onMountEntity(EntityMountEvent event) {
        if (!event.getLevel().m_5776_() && event.isDismounting() && event.getEntityBeingMounted() instanceof AbstractPhoenixEntity && event.getEntityBeingMounted().m_6084_() && event.getEntityMounting().m_6084_() && !event.getEntityBeingMounted().m_20096_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEggImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ThrownEgg && !entity.f_19853_.m_5776_()) {
            RandomSource rand = entity.f_19853_.f_46441_;
            if (((Boolean)ExoticBirdsCommonConfig.allowCreateVanillaEggshell.get()).booleanValue() && rand.m_188503_(3) == 0) {
                entity.m_19983_(new ItemStack((ItemLike)ExoticBirdsItems.EGGSHELL.get(), rand.m_188503_(2) + 1));
            }
        }
    }

    @SubscribeEvent
    public static void checkSpawns(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof AbstractBirdEntity) {
            String currentDimension = event.getEntity().f_19853_.m_6042_().f_63837_().toString();
            for (String dimensionType : (List)ExoticBirdsCommonConfig.blacklistedSpawningDimensions.get()) {
                if (!dimensionType.equals(currentDimension)) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        BirdBookItem.syncLoggedBirds(player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        BirdBookItem.syncLoggedBirds(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        BirdBookItem.syncLoggedBirds(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (event.isWasDeath() && player != null) {
            event.getOriginal().reviveCaps();
            if (BirdTrackingProvider.BIRD_TRACKING_CAPABILITY != null) {
                LazyOptional newStorage = player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY);
                LazyOptional oldStorage = event.getOriginal().getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY);
                if (newStorage.isPresent() && oldStorage.isPresent()) {
                    oldStorage.ifPresent(oldStats -> newStorage.ifPresent(newStats -> newStats.setAll(oldStats.getAll())));
                } else {
                    ExoticBirdsMod.LOGGER.warn("Bird tracking capability for " + player.m_5446_().getString() + " does not exist.");
                }
            }
        }
    }
}

